/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.subscribers.SyncInfo;
import org.eclipse.team.ui.synchronize.actions.SyncInfoFilter;

public class SyncInfoSet {
    Set set = new HashSet();

    public SyncInfoSet(SyncInfo[] infos) {
        this.set.addAll(Arrays.asList(infos));
    }

    public boolean hasConflicts() {
        return this.hasNodes(new SyncInfoFilter.SyncInfoDirectionFilter(12));
    }

    public boolean hasIncomingChanges() {
        return this.hasNodes(new SyncInfoFilter.SyncInfoDirectionFilter(8));
    }

    public boolean hasOutgoingChanges() {
        return this.hasNodes(new SyncInfoFilter.SyncInfoDirectionFilter(4));
    }

    public boolean hasAutoMergeableConflicts() {
        return this.hasNodes(new SyncInfoFilter.AutomergableFilter());
    }

    public void removeConflictingNodes() {
        this.rejectNodes(new SyncInfoFilter.SyncInfoDirectionFilter(12));
    }

    public void removeOutgoingNodes() {
        this.rejectNodes(new SyncInfoFilter.SyncInfoDirectionFilter(4));
    }

    public void removeIncomingNodes() {
        this.rejectNodes(new SyncInfoFilter.SyncInfoDirectionFilter(8));
    }

    public void removeNonMergeableNodes() {
        Iterator it = this.set.iterator();
        while (it.hasNext()) {
            SyncInfo node = (SyncInfo)it.next();
            if ((node.getKind() & 0x40) != 0) {
                it.remove();
                continue;
            }
            if ((node.getKind() & 0xC) == 12) continue;
            it.remove();
        }
    }

    public boolean hasNodes(SyncInfoFilter filter) {
        Iterator it = this.set.iterator();
        while (it.hasNext()) {
            SyncInfo info = (SyncInfo)it.next();
            if (info == null || !filter.select(info)) continue;
            return true;
        }
        return false;
    }

    public void selectNodes(SyncInfoFilter filter) {
        Iterator it = this.set.iterator();
        while (it.hasNext()) {
            SyncInfo info = (SyncInfo)it.next();
            if (info != null && filter.select(info)) continue;
            it.remove();
        }
    }

    public void rejectNodes(SyncInfoFilter filter) {
        Iterator it = this.set.iterator();
        while (it.hasNext()) {
            SyncInfo info = (SyncInfo)it.next();
            if (info == null || !filter.select(info)) continue;
            it.remove();
        }
    }

    public SyncInfo[] getNodes(SyncInfoFilter filter) {
        ArrayList<SyncInfo> result = new ArrayList<SyncInfo>();
        Iterator it = this.set.iterator();
        while (it.hasNext()) {
            SyncInfo info = (SyncInfo)it.next();
            if (info == null || !filter.select(info)) continue;
            result.add(info);
        }
        return result.toArray(new SyncInfo[result.size()]);
    }

    public SyncInfo[] getSyncInfos() {
        return this.set.toArray(new SyncInfo[this.set.size()]);
    }

    public IResource[] getResources() {
        SyncInfo[] changed = this.getSyncInfos();
        IResource[] resources = new IResource[changed.length];
        int i = 0;
        while (i < changed.length) {
            resources[i] = changed[i].getLocal();
            ++i;
        }
        return resources;
    }

    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    public void removeResources(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            this.removeResource(resource);
            ++i;
        }
    }

    public int size() {
        return this.set.size();
    }

    public SyncInfo getNodeFor(IResource resource) {
        Iterator it = this.set.iterator();
        while (it.hasNext()) {
            SyncInfo node = (SyncInfo)it.next();
            if (!node.getLocal().equals((Object)resource)) continue;
            return node;
        }
        return null;
    }

    public void addAll(SyncInfoSet set) {
        SyncInfo[] resources = set.getSyncInfos();
        int i = 0;
        while (i < resources.length) {
            SyncInfo resource = resources[i];
            this.set.add(resource);
            ++i;
        }
    }

    private void removeResource(IResource resource) {
        Iterator it = this.set.iterator();
        while (it.hasNext()) {
            SyncInfo node = (SyncInfo)it.next();
            if (!node.getLocal().equals((Object)resource)) continue;
            it.remove();
            return;
        }
    }
}

