/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.SyncInfo;
import org.eclipse.team.internal.ui.actions.TeamAction;
import org.eclipse.team.ui.synchronize.ITeamSubscriberParticipantNode;
import org.eclipse.team.ui.synchronize.actions.SyncInfoFilter;
import org.eclipse.ui.IViewActionDelegate;

public abstract class SubscriberAction
extends TeamAction
implements IViewActionDelegate {
    public static final QualifiedName SUBSCRIBER_JOB_TYPE = new QualifiedName("org.eclipse.team.ui", "subcriber_job");

    protected SyncInfo[] getSyncInfos() {
        Object[] selected = this.selection.toArray();
        HashSet<SyncInfo> result = new HashSet<SyncInfo>();
        int i = 0;
        while (i < selected.length) {
            Object object = selected[i];
            if (object instanceof ITeamSubscriberParticipantNode) {
                ITeamSubscriberParticipantNode syncResource = (ITeamSubscriberParticipantNode)object;
                SyncInfo[] infos = syncResource.getChildSyncInfos();
                result.addAll(Arrays.asList(infos));
            }
            ++i;
        }
        return result.toArray(new SyncInfo[result.size()]);
    }

    protected boolean isEnabled() throws TeamException {
        return this.getFilteredSyncInfos().length > 0;
    }

    protected boolean select(SyncInfo info) {
        return info != null && this.getSyncInfoFilter().select(info);
    }

    protected SyncInfoFilter getSyncInfoFilter() {
        return new SyncInfoFilter();
    }

    protected SyncInfo[] getFilteredSyncInfos() {
        SyncInfo[] infos = this.getSyncInfos();
        ArrayList<SyncInfo> filtered = new ArrayList<SyncInfo>();
        int i = 0;
        while (i < infos.length) {
            SyncInfo info = infos[i];
            if (this.select(info)) {
                filtered.add(info);
            }
            ++i;
        }
        return filtered.toArray(new SyncInfo[filtered.size()]);
    }
}

