/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.synchronize.TeamSubscriberParticipant;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;

public class DirectionFilterActionGroup
extends ActionGroup
implements IPropertyChangeListener {
    private List actions = new ArrayList(3);
    private DirectionFilterAction incomingMode;
    private DirectionFilterAction outgoingMode;
    private DirectionFilterAction bothMode;
    private DirectionFilterAction conflictsMode;
    private TeamSubscriberParticipant page;
    private int supportedModes;

    public DirectionFilterActionGroup(TeamSubscriberParticipant participant, int supportedModes) {
        this.supportedModes = supportedModes;
        this.page = participant;
        this.createActions();
        participant.addPropertyChangeListener(this);
        this.checkMode(participant.getMode());
    }

    private void createActions() {
        if ((this.supportedModes & 1) != 0) {
            this.incomingMode = new DirectionFilterAction("action.directionFilterIncoming.", "org.eclipse.team.ui.syncview.incomingFilter", 1);
            this.actions.add(this.incomingMode);
        }
        if ((this.supportedModes & 2) != 0) {
            this.outgoingMode = new DirectionFilterAction("action.directionFilterOutgoing.", "org.eclipse.team.ui.syncview.outgoingFilter", 2);
            this.actions.add(this.outgoingMode);
        }
        if ((this.supportedModes & 4) != 0) {
            this.bothMode = new DirectionFilterAction("action.directionFilterBoth.", "org.eclipse.team.ui.syncview.bothFilter", 4);
            this.actions.add(this.bothMode);
        }
        if ((this.supportedModes & 8) != 0) {
            this.conflictsMode = new DirectionFilterAction("action.directionFilterConflicts.", "org.eclipse.team.ui.syncview.conflictsFilter", 8);
            this.actions.add(this.conflictsMode);
        }
    }

    public void fillActionBars(IActionBars actionBars, String group) {
        super.fillActionBars(actionBars);
        IToolBarManager toolBar = actionBars.getToolBarManager();
        Iterator it = this.actions.iterator();
        while (it.hasNext()) {
            DirectionFilterAction action = (DirectionFilterAction)((Object)it.next());
            if (group != null) {
                toolBar.appendToGroup(group, (IAction)action);
                continue;
            }
            toolBar.add((IAction)action);
        }
    }

    public void fillToolBar(IToolBarManager toolBar) {
        Iterator it = this.actions.iterator();
        while (it.hasNext()) {
            DirectionFilterAction action = (DirectionFilterAction)((Object)it.next());
            toolBar.add((IAction)action);
        }
    }

    private void checkMode(int mode) {
        Iterator it = this.actions.iterator();
        while (it.hasNext()) {
            DirectionFilterAction action = (DirectionFilterAction)((Object)it.next());
            if (action.getModeId() == mode) {
                action.setChecked(true);
                continue;
            }
            action.setChecked(false);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.team.ui.P_SYNCVIEWPAGE_MODE")) {
            Integer mode = (Integer)event.getNewValue();
            this.checkMode(mode);
        }
    }

    public void dispose() {
        super.dispose();
    }

    class DirectionFilterAction
    extends Action {
        private int modeId;

        public DirectionFilterAction(String prefix, String commandId, int modeId) {
            super("", 8);
            this.modeId = modeId;
            Utils.initAction((IAction)this, prefix, Policy.getBundle());
            new Action(this){
                final /* synthetic */ DirectionFilterAction this$1;
                {
                    this.this$1 = directionFilterAction;
                }

                public void run() {
                    this.this$1.run();
                }
            };
        }

        public void run() {
            DirectionFilterActionGroup.this.checkMode(this.modeId);
            DirectionFilterActionGroup.this.page.setMode(this.modeId);
        }

        public int getModeId() {
            return this.modeId;
        }
    }
}

