/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.jobs.JobBusyCursor;
import org.eclipse.team.internal.ui.synchronize.actions.ComparisonCriteriaActionGroup;
import org.eclipse.team.internal.ui.synchronize.actions.NavigateAction;
import org.eclipse.team.internal.ui.synchronize.actions.OpenWithActionGroup;
import org.eclipse.team.internal.ui.synchronize.actions.RefactorActionGroup;
import org.eclipse.team.internal.ui.synchronize.actions.RefreshAction;
import org.eclipse.team.internal.ui.synchronize.actions.StatusLineContributionGroup;
import org.eclipse.team.internal.ui.synchronize.actions.SyncViewerShowPreferencesAction;
import org.eclipse.team.internal.ui.synchronize.actions.ToggleViewLayoutAction;
import org.eclipse.team.internal.ui.synchronize.actions.WorkingSetFilterActionGroup;
import org.eclipse.team.internal.ui.synchronize.sets.SubscriberInput;
import org.eclipse.team.internal.ui.synchronize.views.SyncSetContentProvider;
import org.eclipse.team.internal.ui.synchronize.views.SyncSetTableContentProvider;
import org.eclipse.team.internal.ui.synchronize.views.SyncTableViewer;
import org.eclipse.team.internal.ui.synchronize.views.SyncTreeViewer;
import org.eclipse.team.internal.ui.synchronize.views.SyncViewerSorter;
import org.eclipse.team.internal.ui.synchronize.views.SyncViewerTableSorter;
import org.eclipse.team.ui.synchronize.ISynchronizeView;
import org.eclipse.team.ui.synchronize.TeamSubscriberParticipant;
import org.eclipse.team.ui.synchronize.TeamSubscriberParticipantLabelProvider;
import org.eclipse.team.ui.synchronize.actions.SubscriberAction;
import org.eclipse.team.ui.synchronize.actions.SyncInfoFilter;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.PluginAction;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;

public class TeamSubscriberParticipantPage
implements IPageBookViewPage,
IPropertyChangeListener {
    private StructuredViewer viewer;
    private Composite composite = null;
    private boolean settingWorkingSet = false;
    private int layout;
    private SubscriberInput input = null;
    private JobBusyCursor busyCursor;
    private ISynchronizeView view;
    private TeamSubscriberParticipant participant;
    private IPageSite site;
    public static final int[] INCOMING_MODE_FILTER = new int[]{12, 8};
    public static final int[] OUTGOING_MODE_FILTER = new int[]{12, 4};
    public static final int[] BOTH_MODE_FILTER = new int[]{12, 8, 4};
    public static final int[] CONFLICTING_MODE_FILTER = new int[]{12};
    private OpenWithActionGroup openWithActions;
    private NavigateAction gotoNext;
    private NavigateAction gotoPrevious;
    private Action toggleLayoutTree;
    private Action toggleLayoutTable;
    private RefactorActionGroup refactorActions;
    private SyncViewerShowPreferencesAction showPreferences;
    private RefreshAction refreshAllAction;
    private RefreshAction refreshSelectionAction;
    private ComparisonCriteriaActionGroup comparisonCriteriaGroup;
    private Action collapseAll;
    private Action expandAll;
    private WorkingSetFilterActionGroup workingSetGroup;
    private StatusLineContributionGroup statusLine;
    static /* synthetic */ Class class$0;

    public TeamSubscriberParticipantPage(TeamSubscriberParticipant page, ISynchronizeView view, SubscriberInput input) {
        this.participant = page;
        this.view = view;
        this.input = input;
        this.layout = this.getStore().getInt("org.eclipse.team.ui.view_type");
        if (this.layout != 0) {
            this.layout = 1;
        }
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        this.composite.setLayout((Layout)gridLayout);
        this.busyCursor = new JobBusyCursor(parent.getParent().getParent(), SubscriberAction.SUBSCRIBER_JOB_TYPE);
        this.createViewer(this.composite);
        this.openWithActions = new OpenWithActionGroup(this);
        this.refactorActions = new RefactorActionGroup((IWorkbenchPart)this.view);
        this.gotoNext = new NavigateAction(this.view, this, 1);
        this.gotoPrevious = new NavigateAction(this.view, this, 2);
        this.comparisonCriteriaGroup = new ComparisonCriteriaActionGroup(this.input);
        this.toggleLayoutTable = new ToggleViewLayoutAction(this.participant, 1);
        this.toggleLayoutTree = new ToggleViewLayoutAction(this.participant, 0);
        this.workingSetGroup = new WorkingSetFilterActionGroup(this.getSite().getShell(), this, this.view, this.participant);
        this.showPreferences = new SyncViewerShowPreferencesAction(this.view.getSite().getShell());
        this.refreshAllAction = new RefreshAction(this.getSite().getPage(), this.getParticipant(), true);
        this.refreshSelectionAction = new RefreshAction(this.getSite().getPage(), this.getParticipant(), false);
        this.statusLine = new StatusLineContributionGroup(this.getSite().getShell(), this.workingSetGroup, this.getParticipant());
        this.collapseAll = new Action(){

            public void run() {
                TeamSubscriberParticipantPage.this.collapseAll();
            }
        };
        Utils.initAction((IAction)this.collapseAll, "action.collapseAll.");
        this.expandAll = new Action(){

            public void run() {
                StructuredViewer viewer = TeamSubscriberParticipantPage.this.getViewer();
                ISelection selection = viewer.getSelection();
                if (viewer instanceof AbstractTreeViewer && !selection.isEmpty()) {
                    Iterator elements = ((IStructuredSelection)selection).iterator();
                    while (elements.hasNext()) {
                        Object next = elements.next();
                        ((AbstractTreeViewer)viewer).expandToLevel(next, -1);
                    }
                }
            }
        };
        Utils.initAction((IAction)this.expandAll, "action.expandAll.");
        this.participant.addPropertyChangeListener(this);
        TeamUIPlugin.getPlugin().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.updateMode(this.participant.getMode());
    }

    public void init(IPageSite site) throws PartInitException {
        this.site = site;
    }

    private void hookContextMenu() {
        if (this.getViewer() != null) {
            final MenuManager menuMgr = new MenuManager(this.participant.getId());
            menuMgr.setRemoveAllWhenShown(true);
            menuMgr.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    TeamSubscriberParticipantPage.this.setContextMenu(manager);
                }
            });
            Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
            menu.addMenuListener(new MenuListener(){

                public void menuHidden(MenuEvent e) {
                }

                public void menuShown(MenuEvent e) {
                    IContributionItem[] items = menuMgr.getItems();
                    int i = 0;
                    while (i < items.length) {
                        IAction actionItem;
                        IContributionItem item = items[i];
                        if (item instanceof ActionContributionItem && (actionItem = ((ActionContributionItem)item).getAction()) instanceof PluginAction) {
                            ((PluginAction)actionItem).selectionChanged(TeamSubscriberParticipantPage.this.viewer.getSelection());
                        }
                        ++i;
                    }
                }
            });
            this.viewer.getControl().setMenu(menu);
            this.getSite().registerContextMenu(this.participant.getId(), menuMgr, (ISelectionProvider)this.viewer);
        }
    }

    private void setContextMenu(IMenuManager manager) {
        this.openWithActions.fillContextMenu(manager);
        this.refactorActions.fillContextMenu(manager);
        manager.add((IAction)this.refreshSelectionAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.expandAll);
        manager.add((IContributionItem)new Separator("additions"));
    }

    public void switchViewerType(int viewerType) {
        if (this.viewer == null || viewerType != this.layout) {
            if (this.composite == null || this.composite.isDisposed()) {
                return;
            }
            IStructuredSelection oldSelection = null;
            if (this.viewer != null) {
                oldSelection = (IStructuredSelection)this.viewer.getSelection();
            }
            this.layout = viewerType;
            this.getStore().setValue("org.eclipse.team.ui.view_type", this.layout);
            this.disposeChildren(this.composite);
            this.createViewer(this.composite);
            this.composite.layout();
            if (oldSelection != null && oldSelection.size() != 0) {
                this.viewer.setSelection((ISelection)oldSelection, true);
            }
        }
    }

    private void initializeListeners() {
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TeamSubscriberParticipantPage.this.updateStatusLine((IStructuredSelection)event.getSelection());
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TeamSubscriberParticipantPage.this.handleDoubleClick(event);
            }
        });
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                TeamSubscriberParticipantPage.this.handleOpen(event);
            }
        });
    }

    private void createViewer(Composite parent) {
        switch (this.layout) {
            case 0: {
                this.createTreeViewerPartControl(parent);
                break;
            }
            case 1: {
                this.createTableViewerPartControl(parent);
            }
        }
        this.viewer.setInput((Object)this.input);
        this.viewer.getControl().setFocus();
        this.initializeListeners();
        this.hookContextMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
    }

    protected ILabelProvider getLabelProvider() {
        return new TeamSubscriberParticipantLabelProvider();
    }

    private void createTreeViewerPartControl(Composite parent) {
        GridData data = new GridData(1808);
        this.viewer = new SyncTreeViewer(parent, 770);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.viewer.setSorter((ViewerSorter)new SyncViewerSorter(1));
        ((TreeViewer)this.viewer).getTree().setLayoutData((Object)data);
    }

    private void createTableViewerPartControl(Composite parent) {
        Table table = new Table(parent, 66306);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        SyncTableViewer tableViewer = new SyncTableViewer(table);
        this.createColumns(table, layout, tableViewer);
        this.viewer = tableViewer;
        this.viewer.setContentProvider((IContentProvider)new SyncSetTableContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.viewer.setSorter((ViewerSorter)new SyncViewerTableSorter());
    }

    private void createColumns(Table table, TableLayout layout, TableViewer viewer) {
        SelectionListener headerListener = SyncViewerTableSorter.getColumnListener(viewer);
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(Policy.bind("TeamSubscriberParticipantPage.7"));
        col.addSelectionListener(headerListener);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(Policy.bind("TeamSubscriberParticipantPage.8"));
        col.addSelectionListener(headerListener);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
    }

    private void disposeChildren(Composite parent) {
        Control[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            Control control = children[i];
            control.dispose();
            ++i;
        }
    }

    private void handleOpen(OpenEvent event) {
        this.openWithActions.openInCompareEditor();
    }

    private void handleDoubleClick(DoubleClickEvent event) {
        TreeViewer tree;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object element = selection.getFirstElement();
        if (this.viewer instanceof TreeViewer && (tree = (TreeViewer)this.viewer).isExpandable(element)) {
            tree.setExpandedState(element, !tree.getExpandedState(element));
        }
    }

    public void setFocus() {
        if (this.viewer == null) {
            return;
        }
        this.viewer.getControl().setFocus();
    }

    public StructuredViewer getViewer() {
        return this.viewer;
    }

    public void dispose() {
        this.busyCursor.dispose();
        this.statusLine.dispose();
    }

    public SubscriberInput getInput() {
        return this.input;
    }

    public void collapseAll() {
        if (this.viewer == null || !(this.viewer instanceof AbstractTreeViewer)) {
            return;
        }
        this.viewer.getControl().setRedraw(false);
        ((AbstractTreeViewer)this.viewer).collapseToLevel(this.viewer.getInput(), -1);
        this.viewer.getControl().setRedraw(true);
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.ui.part.IShowInSource;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz) {
            return new IShowInSource(){

                public ShowInContext getShowInContext() {
                    StructuredViewer v = TeamSubscriberParticipantPage.this.getViewer();
                    if (v == null) {
                        return null;
                    }
                    return new ShowInContext(null, v.getSelection());
                }
            };
        }
        return null;
    }

    private void updateStatusLine(IStructuredSelection selection) {
        String msg = this.getStatusLineMessage(selection);
        this.getSite().getActionBars().getStatusLineManager().setMessage(msg);
    }

    private String getStatusLineMessage(IStructuredSelection selection) {
        if (selection.size() == 1) {
            IResource resource = this.getResource(selection.getFirstElement());
            if (resource == null) {
                return Policy.bind("SynchronizeView.12");
            }
            return resource.getFullPath().makeRelative().toString();
        }
        if (selection.size() > 1) {
            return String.valueOf(selection.size()) + Policy.bind("SynchronizeView.13");
        }
        return "";
    }

    private IResource getResource(Object object) {
        return SyncSetContentProvider.getResource(object);
    }

    public void selectAll() {
        StructuredViewer viewer = this.getViewer();
        if (viewer instanceof TableViewer) {
            TableViewer table = (TableViewer)viewer;
            table.getTable().selectAll();
        }
    }

    private IPreferenceStore getStore() {
        return TeamUIPlugin.getPlugin().getPreferenceStore();
    }

    public Control getControl() {
        return this.composite;
    }

    public void setActionBars(IActionBars actionBars) {
        if (actionBars != null) {
            IToolBarManager manager = actionBars.getToolBarManager();
            manager.add((IAction)this.refreshAllAction);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.gotoNext);
            manager.add((IAction)this.gotoPrevious);
            manager.add((IAction)this.collapseAll);
            manager.add((IContributionItem)new Separator());
            this.updateViewMenu(actionBars);
            this.statusLine.fillActionBars(actionBars);
        }
    }

    private void updateViewMenu(IActionBars actionBars) {
        IMenuManager menu = actionBars.getMenuManager();
        MenuManager layoutMenu = new MenuManager(Policy.bind("action.layout.label"));
        layoutMenu.add((IAction)this.toggleLayoutTable);
        layoutMenu.add((IAction)this.toggleLayoutTree);
        MenuManager comparisonCriteria = new MenuManager(Policy.bind("action.comparisonCriteria.label"));
        this.comparisonCriteriaGroup.addActionsToMenuMgr((IMenuManager)comparisonCriteria);
        this.workingSetGroup.fillActionBars(actionBars);
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)comparisonCriteria);
        menu.add((IContributionItem)layoutMenu);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.showPreferences);
    }

    public IPageSite getSite() {
        return this.site;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.team.ui.P_SYNCVIEWPAGE_LAYOUT")) {
            this.switchViewerType((Integer)event.getNewValue());
        } else if (event.getProperty().equals("org.eclipse.team.ui.P_SYNCVIEWPAGE_MODE")) {
            this.updateMode((Integer)event.getNewValue());
        } else if (event.getProperty().equals("changeWorkingSet")) {
            if (this.settingWorkingSet) {
                return;
            }
            this.settingWorkingSet = true;
            this.participant.setWorkingSet((IWorkingSet)event.getNewValue());
            this.settingWorkingSet = false;
        } else if (event.getProperty().equals("org.eclipse.team.ui.P_SYNCVIEWPAGE_WORKINGSET")) {
            if (this.settingWorkingSet) {
                return;
            }
            this.settingWorkingSet = true;
            Object newValue = event.getNewValue();
            if (newValue instanceof IWorkingSet) {
                this.workingSetGroup.setWorkingSet((IWorkingSet)newValue);
            } else if (newValue == null) {
                this.workingSetGroup.setWorkingSet(null);
            }
            this.settingWorkingSet = false;
        } else if (event.getProperty().equals("org.eclipse.team.ui.view_syncinfo_in_label")) {
            this.getViewer().refresh(true);
        }
    }

    private void updateMode(int mode) {
        int[] modeFilter = BOTH_MODE_FILTER;
        switch (mode) {
            case 1: {
                modeFilter = INCOMING_MODE_FILTER;
                break;
            }
            case 2: {
                modeFilter = OUTGOING_MODE_FILTER;
                break;
            }
            case 4: {
                modeFilter = BOTH_MODE_FILTER;
                break;
            }
            case 8: {
                modeFilter = CONFLICTING_MODE_FILTER;
            }
        }
        try {
            this.input.setFilter(new SyncInfoFilter.AndSyncInfoFilter(new SyncInfoFilter[]{new SyncInfoFilter.SyncInfoDirectionFilter(modeFilter), new SyncInfoFilter.SyncInfoChangeTypeFilter(new int[]{1, 2, 3}), new SyncInfoFilter.PseudoConflictFilter()}), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (TeamException e) {
            Utils.handleError(this.getSite().getShell(), (Exception)((Object)e), Policy.bind("SynchronizeView.16"), e.getMessage());
        }
    }

    public TeamSubscriberParticipant getParticipant() {
        return this.participant;
    }

    public ISynchronizeView getSynchronizeView() {
        return this.view;
    }
}

