/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.subscribers.SyncInfo;
import org.eclipse.team.internal.ui.OverlayIcon;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.jobs.IJobListener;
import org.eclipse.team.internal.ui.jobs.JobStatusHandler;
import org.eclipse.team.internal.ui.synchronize.sets.SubscriberInput;
import org.eclipse.team.internal.ui.synchronize.sets.SyncInfoStatistics;
import org.eclipse.team.internal.ui.synchronize.sets.SyncSet;
import org.eclipse.team.internal.ui.synchronize.views.CompressedFolder;
import org.eclipse.team.internal.ui.synchronize.views.SyncSetContentProvider;
import org.eclipse.team.internal.ui.synchronize.views.SynchronizeViewNode;
import org.eclipse.team.ui.synchronize.TeamSubscriberParticipantLabelProvider;
import org.eclipse.team.ui.synchronize.actions.SubscriberAction;
import org.eclipse.ui.internal.WorkbenchColors;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class TeamSubscriberParticipantLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private static final int COL_RESOURCE = 0;
    private static final int COL_PARENT = 1;
    private boolean working = false;
    private Image compressedFolderImage;
    private Map fgImageCache;
    CompareConfiguration compareConfig = new CompareConfiguration();
    WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();

    public Image getCompressedFolderImage() {
        if (this.compressedFolderImage == null) {
            this.compressedFolderImage = TeamUIPlugin.getImageDescriptor("obj/compressed_folder_obj.gif").createImage();
        }
        return this.compressedFolderImage;
    }

    public TeamSubscriberParticipantLabelProvider() {
        JobStatusHandler.addJobListener(new IJobListener(){

            public void started(QualifiedName jobType) {
                TeamSubscriberParticipantLabelProvider.this.working = true;
                Display.getDefault().asyncExec(new Runnable(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        2 var1_1 = this;
                        synchronized (var1_1) {
                            TeamSubscriberParticipantLabelProvider.access$1(1.access$0(this.this$1), new LabelProviderChangedEvent((IBaseLabelProvider)1.access$0(this.this$1)));
                        }
                    }
                });
            }

            public void finished(QualifiedName jobType) {
                TeamSubscriberParticipantLabelProvider.this.working = false;
                Display.getDefault().asyncExec(new Runnable(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        3 var1_1 = this;
                        synchronized (var1_1) {
                            TeamSubscriberParticipantLabelProvider.access$1(1.access$0(this.this$1), new LabelProviderChangedEvent((IBaseLabelProvider)1.access$0(this.this$1)));
                        }
                    }
                });
            }

            static /* synthetic */ TeamSubscriberParticipantLabelProvider access$0(1 var0) {
                return var0.TeamSubscriberParticipantLabelProvider.this;
            }
        }, SubscriberAction.SUBSCRIBER_JOB_TYPE);
        this.working = JobStatusHandler.hasRunningJobs(SubscriberAction.SUBSCRIBER_JOB_TYPE);
    }

    protected String decorateText(String input, Object resource) {
        return input;
    }

    protected Image decorateImage(Image base, Object resource) {
        return base;
    }

    public String getText(Object element) {
        SyncInfo info;
        IResource resource = SyncSetContentProvider.getResource(element);
        String name = element instanceof CompressedFolder ? resource.getProjectRelativePath().toString() : this.workbenchLabelProvider.getText((Object)resource);
        if (TeamUIPlugin.getPlugin().getPreferenceStore().getBoolean("org.eclipse.team.ui.view_syncinfo_in_label") && (info = SyncSetContentProvider.getSyncInfo(element)) != null && info.getKind() != 0) {
            String syncKindString = SyncInfo.kindToString((int)info.getKind());
            name = Policy.bind("TeamSubscriberSyncPage.labelWithSyncKind", name, syncKindString);
        }
        return this.decorateText(name, resource);
    }

    public Image getImage(Object element) {
        Image decoratedImage = null;
        IResource resource = SyncSetContentProvider.getResource(element);
        if (element instanceof CompressedFolder) {
            decoratedImage = this.compareConfig.getImage(this.getCompressedFolderImage(), 0);
        } else {
            Image image = this.workbenchLabelProvider.getImage((Object)resource);
            decoratedImage = this.getCompareImage(image, element);
        }
        decoratedImage = this.propagateConflicts(decoratedImage, element, resource);
        return this.decorateImage(decoratedImage, element);
    }

    private Image getCompareImage(Image base, Object element) {
        int kind = SyncSetContentProvider.getSyncKind(element);
        switch (kind & 0xC) {
            case 4: {
                kind = kind & 0xFFFFFFFB | 8;
                break;
            }
            case 8: {
                kind = kind & 0xFFFFFFF7 | 4;
            }
        }
        return this.compareConfig.getImage(base, kind);
    }

    private Image propagateConflicts(Image base, Object element, IResource resource) {
        int kind;
        if (element instanceof SynchronizeViewNode && resource.getType() != 1 && ((kind = SyncSetContentProvider.getSyncKind(element)) & 0xC) != 12) {
            SubscriberInput input = ((SynchronizeViewNode)element).getSubscriberInput();
            SyncSet set = new SyncSet();
            SyncInfo[] infos = input.getWorkingSetSyncSet().getOutOfSyncDescendants(resource);
            int i = 0;
            while (i < infos.length) {
                set.add(infos[i]);
                ++i;
            }
            SyncInfoStatistics stats = set.getStatistics();
            long count = stats.countFor(12, 12);
            if (count > 0L) {
                Image conflictDecoratedImage;
                OverlayIcon overlay = new OverlayIcon(base, new ImageDescriptor[]{TeamUIPlugin.getImageDescriptor("ovr/confchg_ov.gif")}, new int[]{2}, new Point(base.getBounds().width, base.getBounds().height));
                if (this.fgImageCache == null) {
                    this.fgImageCache = new HashMap(10);
                }
                if ((conflictDecoratedImage = (Image)this.fgImageCache.get((Object)overlay)) == null) {
                    conflictDecoratedImage = overlay.createImage();
                    this.fgImageCache.put(overlay, conflictDecoratedImage);
                }
                return conflictDecoratedImage;
            }
        }
        return base;
    }

    public void dispose() {
        super.dispose();
        this.workbenchLabelProvider.dispose();
        this.compareConfig.dispose();
        if (this.compressedFolderImage != null) {
            this.compressedFolderImage.dispose();
        }
        if (this.fgImageCache != null) {
            Iterator it = this.fgImageCache.values().iterator();
            while (it.hasNext()) {
                Image element = (Image)it.next();
                element.dispose();
            }
        }
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        if (columnIndex == 1) {
            SyncSetContentProvider.getResource(element);
            return null;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getText(element);
        }
        if (columnIndex == 1) {
            IResource resource = SyncSetContentProvider.getResource(element);
            return resource.getParent().getFullPath().toString();
        }
        return null;
    }

    public Color getForeground(Object element) {
        if (this.working) {
            return WorkbenchColors.getSystemColor((int)18);
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    static /* synthetic */ void access$1(TeamSubscriberParticipantLabelProvider teamSubscriberParticipantLabelProvider, LabelProviderChangedEvent labelProviderChangedEvent) {
        teamSubscriberParticipantLabelProvider.fireLabelProviderChanged(labelProviderChangedEvent);
    }
}

