/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.subscribers.TeamSubscriber;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.jobs.RefreshSubscriberInputJob;
import org.eclipse.team.internal.ui.synchronize.actions.RefreshAction;
import org.eclipse.team.internal.ui.synchronize.sets.SubscriberInput;
import org.eclipse.team.ui.synchronize.AbstractSynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeView;
import org.eclipse.team.ui.synchronize.TeamSubscriberParticipantPage;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPageBookViewPage;

public abstract class TeamSubscriberParticipant
extends AbstractSynchronizeParticipant {
    private SubscriberInput input;
    private int currentMode;
    private int currentLayout;
    private IWorkingSet workingSet;
    private static final String CTX_SUBSCRIBER_PARTICIPANT_SETTINGS = "org.eclipse.team.ui.TEAMSUBSRCIBERSETTINGS";
    public static final String P_SYNCVIEWPAGE_WORKINGSET = "org.eclipse.team.ui.P_SYNCVIEWPAGE_WORKINGSET";
    public static final String P_SYNCVIEWPAGE_MODE = "org.eclipse.team.ui.P_SYNCVIEWPAGE_MODE";
    public static final int INCOMING_MODE = 1;
    public static final int OUTGOING_MODE = 2;
    public static final int BOTH_MODE = 4;
    public static final int CONFLICTING_MODE = 8;
    public static final int ALL_MODES = 15;
    public static final String P_SYNCVIEWPAGE_LAYOUT = "org.eclipse.team.ui.P_SYNCVIEWPAGE_LAYOUT";
    public static final int TREE_LAYOUT = 0;
    public static final int TABLE_LAYOUT = 1;

    public IPageBookViewPage createPage(ISynchronizeView view) {
        return new TeamSubscriberParticipantPage(this, view, this.input);
    }

    public void setMode(int mode) {
        int oldMode = this.getMode();
        this.currentMode = mode;
        TeamUIPlugin.getPlugin().getPreferenceStore().setValue("org.eclipse.team.ui.syncview_selected_mode", mode);
        this.firePropertyChange(this, P_SYNCVIEWPAGE_MODE, new Integer(oldMode), new Integer(mode));
    }

    public int getMode() {
        return this.currentMode;
    }

    public void setLayout(int layout) {
        int oldLayout = this.currentLayout;
        this.currentLayout = layout;
        this.firePropertyChange(this, P_SYNCVIEWPAGE_LAYOUT, new Integer(oldLayout), new Integer(layout));
    }

    public int getLayout() {
        return this.currentLayout;
    }

    public void setWorkingSet(IWorkingSet set) {
        SubscriberInput input = this.getInput();
        IWorkingSet oldSet = null;
        if (input != null) {
            oldSet = input.getWorkingSet();
            input.setWorkingSet(set);
            this.workingSet = null;
        } else {
            this.workingSet = set;
        }
        this.firePropertyChange(this, P_SYNCVIEWPAGE_WORKINGSET, oldSet, set);
    }

    public IWorkingSet getWorkingSet() {
        SubscriberInput input = this.getInput();
        if (input != null) {
            return this.getInput().getWorkingSet();
        }
        return this.workingSet;
    }

    public void refreshWithRemote(IResource[] resources) {
        if (resources == null || resources.length == 0) {
            RefreshAction.run(this.input.workingSetRoots(), this);
        } else {
            RefreshAction.run(resources, this);
        }
    }

    public void dispose() {
        RefreshSubscriberInputJob refreshJob = TeamUIPlugin.getPlugin().getRefreshJob();
        refreshJob.removeSubscriberInput(this.input);
        this.input.dispose();
    }

    public SubscriberInput getInput() {
        return this.input;
    }

    protected void setSubscriber(TeamSubscriber subscriber) {
        this.input = new SubscriberInput(this, subscriber);
        if (this.workingSet != null) {
            this.setWorkingSet(this.workingSet);
        }
    }

    public void init(IMemento memento) throws PartInitException {
        if (memento != null) {
            IMemento settings = memento.getChild(CTX_SUBSCRIBER_PARTICIPANT_SETTINGS);
            if (settings != null) {
                IWorkingSet workingSet;
                String set = settings.getString(P_SYNCVIEWPAGE_WORKINGSET);
                String mode = settings.getString(P_SYNCVIEWPAGE_MODE);
                String layout = settings.getString(P_SYNCVIEWPAGE_LAYOUT);
                if (set != null && (workingSet = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(set)) != null) {
                    this.setWorkingSet(workingSet);
                }
                this.setMode(Integer.parseInt(mode));
                this.setLayout(Integer.parseInt(layout));
            }
        } else {
            this.setMode(4);
            this.setLayout(0);
        }
    }

    public void saveState(IMemento memento) {
        IMemento settings = memento.createChild(CTX_SUBSCRIBER_PARTICIPANT_SETTINGS);
        IWorkingSet set = this.getWorkingSet();
        if (set != null) {
            settings.putString(P_SYNCVIEWPAGE_WORKINGSET, this.getWorkingSet().getName());
        }
        settings.putString(P_SYNCVIEWPAGE_LAYOUT, Integer.toString(this.getLayout()));
        settings.putString(P_SYNCVIEWPAGE_MODE, Integer.toString(this.getMode()));
    }
}

