/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.wizards;

import java.io.File;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.wizards.TeamWizardPage;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.help.WorkbenchHelp;

public class ImportProjectSetMainPage
extends TeamWizardPage {
    Text fileText;
    String file = "";
    Button browseButton;
    Button createWorkingSetButton;
    Text workingSetNameField;
    private boolean createWorkingSet = false;
    private String workingSetName = "";
    private static final int SIZING_TEXT_FIELD_WIDTH = 80;

    public ImportProjectSetMainPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 1);
        this.initializeDialogUnits((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.team.ui.import_project_set_page_context");
        Composite inner = new Composite(composite, 0);
        inner.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        this.createLabel(inner, Policy.bind("ImportProjectSetMainPage.Project_Set_File_Name__2"));
        this.fileText = this.createTextField(inner);
        if (this.file != null) {
            this.fileText.setText(this.file);
        }
        this.fileText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                ImportProjectSetMainPage.this.file = ImportProjectSetMainPage.this.fileText.getText();
                ImportProjectSetMainPage.this.updateEnablement();
            }
        });
        this.browseButton = new Button(inner, 8);
        this.browseButton.setText(Policy.bind("ImportProjectSetMainPage.Browse_3"));
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.heightHint = this.convertVerticalDLUsToPixels(14);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.browseButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.browseButton.setLayoutData((Object)data);
        this.browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog d = new FileDialog(ImportProjectSetMainPage.this.getShell());
                d.setFilterExtensions(new String[]{"*.psf", "*"});
                d.setFilterNames(new String[]{Policy.bind("ImportProjectSetMainPage.Project_Set_Files_2"), Policy.bind("ImportProjectSetMainPage.allFiles")});
                d.setFilterPath(new File(".").getAbsolutePath());
                String f = d.open();
                if (f != null) {
                    ImportProjectSetMainPage.this.fileText.setText(f);
                    ImportProjectSetMainPage.this.file = f;
                }
            }
        });
        this.createWorkinSetCreationArea(inner, 3);
        this.setControl((Control)composite);
        this.updateEnablement();
        Dialog.applyDialogFont((Control)parent);
    }

    private void createWorkinSetCreationArea(Composite composite, int numColumns) {
        this.createWorkingSetButton = new Button(composite, 131104);
        this.createWorkingSetButton.setText(Policy.bind("ImportProjectSetMainPage.createWorkingSetLabel"));
        this.createWorkingSetButton.setSelection(this.createWorkingSet);
        GridData data = new GridData();
        data.horizontalSpan = numColumns;
        this.createWorkingSetButton.setLayoutData((Object)data);
        final Label label = new Label(composite, 0);
        label.setText(Policy.bind("ImportProjectSetMainPage.workingSetLabel"));
        data = new GridData();
        data.horizontalSpan = 1;
        label.setLayoutData((Object)data);
        label.setEnabled(this.createWorkingSet);
        this.workingSetNameField = new Text(composite, 2048);
        data = new GridData(768);
        data.widthHint = 80;
        data.horizontalSpan = 1;
        this.workingSetNameField.setLayoutData((Object)data);
        this.workingSetNameField.setEnabled(this.createWorkingSet);
        this.createWorkingSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportProjectSetMainPage.this.createWorkingSet = ImportProjectSetMainPage.this.createWorkingSetButton.getSelection();
                label.setEnabled(ImportProjectSetMainPage.this.createWorkingSet);
                ImportProjectSetMainPage.this.workingSetNameField.setEnabled(ImportProjectSetMainPage.this.createWorkingSet);
                ImportProjectSetMainPage.this.updateEnablement();
            }
        });
        this.workingSetNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportProjectSetMainPage.this.updateEnablement();
            }
        });
    }

    private boolean validateWorkingSetName() {
        if (this.createWorkingSet) {
            this.workingSetName = this.workingSetNameField.getText();
            if (this.workingSetName.length() == 0) {
                this.setMessage(Policy.bind("ImportProjectSetMainPage.workingSetNameEmpty"), 3);
                return false;
            }
            IWorkingSet existingSet = TeamUIPlugin.getPlugin().getWorkbench().getWorkingSetManager().getWorkingSet(this.workingSetName);
            if (existingSet != null) {
                this.setMessage(Policy.bind("ImportProjectSetMainPage.workingSetNameExists"), 2);
                return true;
            }
        }
        this.setMessage(null);
        return true;
    }

    private void updateEnablement() {
        boolean complete;
        this.setMessage(null);
        if (this.file.length() == 0) {
            complete = false;
        } else {
            File f = new File(this.file);
            if (!f.exists()) {
                this.setMessage(Policy.bind("ImportProjectSetMainPage.The_specified_file_does_not_exist_4"), 3);
                complete = false;
            } else if (f.isDirectory()) {
                this.setMessage(Policy.bind("ImportProjectSetMainPage.You_have_specified_a_folder_5"), 3);
                complete = false;
            } else {
                complete = this.validateWorkingSetName();
            }
        }
        this.setPageComplete(complete);
    }

    public String getFileName() {
        return this.file;
    }

    public void setFileName(String file) {
        if (file != null) {
            this.file = file;
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fileText.setFocus();
        }
    }

    public String getWorkingSetName() {
        if (!this.createWorkingSet) {
            return null;
        }
        return this.workingSetName;
    }
}

