/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.views;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.synchronize.views.SyncViewerSorter;

public class SyncViewerTableSorter
extends SyncViewerSorter {
    private boolean reversed;
    private int columnNumber;
    public static final int COL_NAME = 0;
    public static final int COL_PARENT = 1;
    private int[][] SORT_ORDERS_BY_COLUMN;

    public static SelectionListener getColumnListener(final TableViewer tableViewer) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int column = tableViewer.getTable().indexOf((TableColumn)e.widget);
                SyncViewerTableSorter oldSorter = (SyncViewerTableSorter)tableViewer.getSorter();
                if (oldSorter != null && column == oldSorter.getColumnNumber()) {
                    SyncViewerTableSorter.getStore().setValue("org.eclipse.team.ui.table_column_sort_reversed", !oldSorter.isReversed());
                    oldSorter.setReversed(!oldSorter.isReversed());
                    tableViewer.refresh();
                } else {
                    SyncViewerTableSorter.getStore().setValue("org.eclipse.team.ui.table_column_sort", column);
                    SyncViewerTableSorter.getStore().setValue("org.eclipse.team.ui.table_column_sort_reversed", false);
                    tableViewer.setSorter((ViewerSorter)new SyncViewerTableSorter());
                }
            }
        };
    }

    public SyncViewerTableSorter() {
        super(1);
        int[][] nArrayArray = new int[2][];
        int[] nArray = new int[2];
        nArray[1] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[2];
        nArray2[0] = 1;
        nArrayArray[1] = nArray2;
        this.SORT_ORDERS_BY_COLUMN = nArrayArray;
        this.columnNumber = SyncViewerTableSorter.getStore().getInt("org.eclipse.team.ui.table_column_sort");
        this.reversed = SyncViewerTableSorter.getStore().getBoolean("org.eclipse.team.ui.table_column_sort_reversed");
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        IResource resource1 = this.getResource(e1);
        IResource resource2 = this.getResource(e2);
        int result = 0;
        if (resource1 == null || resource2 == null) {
            result = super.compare(viewer, e1, e2);
        } else {
            int[] columnSortOrder = this.SORT_ORDERS_BY_COLUMN[this.columnNumber];
            int i = 0;
            while (i < columnSortOrder.length) {
                result = this.compareColumnValue(columnSortOrder[i], resource1, resource2);
                if (result != 0) break;
                ++i;
            }
        }
        if (this.reversed) {
            result = -result;
        }
        return result;
    }

    int compareColumnValue(int columnNumber, IResource e1, IResource e2) {
        switch (columnNumber) {
            case 0: {
                int cat1 = this.category(e1);
                int cat2 = this.category(e2);
                if (cat1 != cat2) {
                    return cat1 - cat2;
                }
                return this.getCollator().compare(e1.getName(), e2.getName());
            }
            case 1: {
                return this.getCollator().compare(e1.getParent().getFullPath().toString(), e2.getParent().getFullPath().toString());
            }
        }
        return 0;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public void setReversed(boolean newReversed) {
        this.reversed = newReversed;
    }

    private static IPreferenceStore getStore() {
        return TeamUIPlugin.getPlugin().getPreferenceStore();
    }
}

