/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.views;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.synchronize.actions.INavigableControl;
import org.eclipse.team.internal.ui.synchronize.views.CompressedFolderContentProvider;
import org.eclipse.team.internal.ui.synchronize.views.SyncSetContentProvider;
import org.eclipse.team.internal.ui.synchronize.views.SyncSetTreeContentProvider;

public class SyncTreeViewer
extends TreeViewer
implements INavigableControl {
    private IPropertyChangeListener propertyListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("org.eclipse.team.ui.compress_folders")) {
                SyncTreeViewer.this.setTreeViewerContentProvider();
            }
        }
    };

    public SyncTreeViewer(Composite parent, int style) {
        super(parent, style);
        this.getStore().addPropertyChangeListener(this.propertyListener);
        this.setTreeViewerContentProvider();
    }

    private void setTreeViewerContentProvider() {
        if (this.getStore().getBoolean("org.eclipse.team.ui.compress_folders")) {
            this.setContentProvider((IContentProvider)new CompressedFolderContentProvider());
        } else {
            this.setContentProvider((IContentProvider)new SyncSetTreeContentProvider());
        }
    }

    private IPreferenceStore getStore() {
        return TeamUIPlugin.getPlugin().getPreferenceStore();
    }

    protected void handleLabelProviderChanged(LabelProviderChangedEvent event) {
        Object[] changed = event.getElements();
        if (changed != null && this.getInput() != null) {
            ArrayList<Object> others = new ArrayList<Object>();
            int i = 0;
            while (i < changed.length) {
                IContentProvider provider;
                Object curr = changed[i];
                if (curr instanceof IResource && (provider = this.getContentProvider()) != null && provider instanceof SyncSetContentProvider) {
                    curr = ((SyncSetContentProvider)provider).getModelObject((IResource)curr);
                }
                others.add(curr);
                ++i;
            }
            if (others.isEmpty()) {
                return;
            }
            event = new LabelProviderChangedEvent((IBaseLabelProvider)event.getSource(), others.toArray());
        }
        super.handleLabelProviderChanged(event);
    }

    protected void handleDispose(DisposeEvent event) {
        super.handleDispose(event);
        this.getStore().removePropertyChangeListener(this.propertyListener);
    }

    public boolean gotoDifference(int direction) {
        boolean next = direction == 1;
        return this.internalNavigate(next, false);
    }

    private boolean internalNavigate(boolean next, boolean fireOpen) {
        Control c = this.getControl();
        if (!(c instanceof Tree)) {
            return false;
        }
        Tree tree = (Tree)c;
        TreeItem item = null;
        TreeItem[] children = tree.getSelection();
        if (children != null && children.length > 0) {
            item = children[0];
        }
        if (item == null && (children = tree.getItems()) != null && children.length > 0 && (item = children[0]) != null && item.getItemCount() <= 0) {
            this.internalSetSelection(item, fireOpen);
            return false;
        }
        while ((item = this.findNextPrev(item, next)) != null && item.getItemCount() > 0) {
        }
        if (item != null) {
            this.internalSetSelection(item, fireOpen);
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private TreeItem findNextPrev(TreeItem item, boolean next) {
        if (item == null) {
            return null;
        }
        children = null;
        if (!next) {
            parent = item.getParentItem();
            children = parent != null ? parent.getItems() : item.getParent().getItems();
            if (children != null && children.length > 0) {
                index = 0;
                while (index < children.length) {
                    if (children[index] == item) break;
                    ++index;
                }
                if (index > 0) {
                    item = children[index - 1];
                    while (true) {
                        this.createChildren((Widget)item);
                        n = item.getItemCount();
                        if (n <= 0) break;
                        item.setExpanded(true);
                        item = item.getItems()[n - 1];
                    }
                    return item;
                }
            }
            return parent;
        }
        item.setExpanded(true);
        this.createChildren((Widget)item);
        if (item.getItemCount() <= 0) ** GOTO lbl41
        children = item.getItems();
        return children[0];
lbl-1000:
        // 1 sources

        {
            children = null;
            parent = item.getParentItem();
            children = parent != null ? parent.getItems() : item.getParent().getItems();
            if (children != null && children.length > 0) {
                index = 0;
                while (index < children.length) {
                    if (children[index] == item) break;
                    ++index;
                }
                if (index < children.length - 1) {
                    return children[index + 1];
                }
            }
            item = parent;
lbl41:
            // 2 sources

            ** while (item != null)
        }
lbl42:
        // 1 sources

        return item;
    }

    private void internalSetSelection(TreeItem ti, boolean fireOpen) {
        Object data;
        if (ti != null && (data = ti.getData()) != null) {
            StructuredSelection selection = new StructuredSelection(data);
            this.setSelection((ISelection)selection, true);
            ISelection currentSelection = this.getSelection();
            if (fireOpen && currentSelection != null && selection.equals(currentSelection)) {
                this.fireOpen(new OpenEvent((Viewer)this, (ISelection)selection));
            }
        }
    }

    public void preserveState(int direction) {
    }

    public void restoreState(int direction) {
    }
}

