/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.views;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.team.internal.ui.synchronize.sets.SubscriberInput;
import org.eclipse.team.internal.ui.synchronize.sets.SyncSetChangedEvent;
import org.eclipse.team.internal.ui.synchronize.views.SyncSetContentProvider;

public class SyncSetTreeContentProvider
extends SyncSetContentProvider
implements ITreeContentProvider {
    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object element) {
        IResource resource = SyncSetContentProvider.getResource(element);
        if (resource != null) {
            return this.members(resource);
        }
        if (element instanceof SubscriberInput) {
            return this.members((IResource)ResourcesPlugin.getWorkspace().getRoot());
        }
        return new Object[0];
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object getParent(Object element) {
        IResource resource = SyncSetContentProvider.getResource(element);
        if (resource == null) {
            return null;
        }
        IContainer parent = resource.getParent();
        return this.getModelObject((IResource)parent);
    }

    public AbstractTreeViewer getTreeViewer() {
        if (this.viewer instanceof AbstractTreeViewer) {
            return (AbstractTreeViewer)this.viewer;
        }
        return null;
    }

    protected void handleResourceAdditions(SyncSetChangedEvent event) {
        AbstractTreeViewer tree = this.getTreeViewer();
        if (tree != null) {
            IResource[] added = event.getAddedRoots();
            int i = 0;
            while (i < added.length) {
                IResource resource = added[i];
                Object parent = resource.getType() == 4 ? this.getSubscriberInput() : this.getModelParent(resource);
                Object element = this.getModelObject(resource);
                tree.add(parent, element);
                this.updateParentLabels(resource);
                ++i;
            }
        } else {
            super.handleResourceAdditions(event);
        }
    }

    protected void handleResourceRemovals(SyncSetChangedEvent event) {
        AbstractTreeViewer tree = this.getTreeViewer();
        if (tree != null) {
            IResource[] roots = event.getRemovedRoots();
            if (roots.length == 0) {
                return;
            }
            Object[] modelRoots = new Object[roots.length];
            int i = 0;
            while (i < modelRoots.length) {
                modelRoots[i] = this.getModelObject(roots[i]);
                this.updateParentLabels(roots[i]);
                ++i;
            }
            tree.remove(modelRoots);
        } else {
            super.handleResourceRemovals(event);
        }
    }

    protected Object getModelParent(IResource resource) {
        return this.getModelObject((IResource)resource.getParent());
    }
}

