/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.views;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.team.core.subscribers.SyncInfo;
import org.eclipse.team.internal.ui.synchronize.sets.SyncSetChangedEvent;
import org.eclipse.team.internal.ui.synchronize.views.SyncSetContentProvider;

public class SyncSetTableContentProvider
extends SyncSetContentProvider {
    public Object[] getElements(Object element) {
        SyncInfo[] infos = this.getSyncSet().allMembers();
        return this.getModelObjects(infos);
    }

    public TableViewer getTableViewer() {
        if (this.viewer instanceof TableViewer) {
            return (TableViewer)this.viewer;
        }
        return null;
    }

    protected void handleResourceAdditions(SyncSetChangedEvent event) {
        TableViewer table = this.getTableViewer();
        if (table != null) {
            SyncInfo[] infos = event.getAddedResources();
            table.add(this.getModelObjects(infos));
        } else {
            super.handleResourceAdditions(event);
        }
    }

    protected void handleResourceRemovals(SyncSetChangedEvent event) {
        TableViewer table = this.getTableViewer();
        if (table != null) {
            IResource[] resources = event.getRemovedResources();
            table.remove(this.getModelObjects(resources));
        } else {
            super.handleResourceRemovals(event);
        }
    }

    protected Object getModelObject(SyncInfo info) {
        return this.getModelObject(info.getLocal());
    }

    protected Object[] getModelObjects(SyncInfo[] infos) {
        Object[] resources = new Object[infos.length];
        int i = 0;
        while (i < resources.length) {
            resources[i] = this.getModelObject(infos[i]);
            ++i;
        }
        return resources;
    }
}

