/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.views;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.subscribers.SyncInfo;
import org.eclipse.team.internal.ui.synchronize.sets.ISyncSetChangedListener;
import org.eclipse.team.internal.ui.synchronize.sets.SubscriberInput;
import org.eclipse.team.internal.ui.synchronize.sets.SyncSet;
import org.eclipse.team.internal.ui.synchronize.sets.SyncSetChangedEvent;
import org.eclipse.team.internal.ui.synchronize.views.SynchronizeViewNode;

public abstract class SyncSetContentProvider
implements IStructuredContentProvider,
ISyncSetChangedListener {
    protected Viewer viewer;
    private Set parentsToUpdate = new HashSet();

    protected SyncSet getSyncSet() {
        SubscriberInput input = this.getSubscriberInput();
        if (input == null) {
            return null;
        }
        return input.getFilteredSyncSet();
    }

    protected SubscriberInput getSubscriberInput() {
        if (this.viewer == null || this.viewer.getControl().isDisposed()) {
            return null;
        }
        return (SubscriberInput)this.viewer.getInput();
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        this.viewer = v;
        SubscriberInput oldSubscriberInput = null;
        SubscriberInput newSubscriberInput = null;
        if (oldInput instanceof SubscriberInput) {
            oldSubscriberInput = (SubscriberInput)oldInput;
        }
        if (newInput instanceof SubscriberInput) {
            newSubscriberInput = (SubscriberInput)newInput;
        }
        if (oldSubscriberInput != newSubscriberInput) {
            if (oldSubscriberInput != null) {
                oldSubscriberInput.getFilteredSyncSet().removeSyncSetChangedListener(this);
            }
            if (newSubscriberInput != null) {
                newSubscriberInput.getFilteredSyncSet().addSyncSetChangedListener(this);
            }
        }
    }

    public abstract Object[] getElements(Object var1);

    public void dispose() {
        SubscriberInput input = this.getSubscriberInput();
        if (input != null) {
            input.getFilteredSyncSet().removeSyncSetChangedListener(this);
        }
    }

    public void syncSetChanged(final SyncSetChangedEvent event) {
        final Control ctrl = this.viewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            ctrl.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!ctrl.isDisposed()) {
                        BusyIndicator.showWhile((Display)ctrl.getDisplay(), (Runnable)new Runnable(this, event){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ SyncSetChangedEvent val$event;
                            {
                                this.this$1 = var1_1;
                                this.val$event = syncSetChangedEvent;
                            }

                            public void run() {
                                1.access$0(this.this$1).handleSyncSetChanges(this.val$event);
                            }
                        });
                    }
                }

                static /* synthetic */ SyncSetContentProvider access$0(1 var0) {
                    return var0.SyncSetContentProvider.this;
                }
            });
        }
    }

    protected void handleSyncSetChanges(SyncSetChangedEvent event) {
        this.viewer.getControl().setRedraw(false);
        if (event.isReset()) {
            ((StructuredViewer)this.viewer).refresh();
        } else {
            this.handleResourceChanges(event);
            this.handleResourceRemovals(event);
            this.handleResourceAdditions(event);
            this.updateParentLabels();
        }
        this.viewer.getControl().setRedraw(true);
    }

    protected void handleResourceChanges(SyncSetChangedEvent event) {
        SyncInfo[] infos = event.getChangedResources();
        int i = 0;
        while (i < infos.length) {
            IResource local = infos[i].getLocal();
            ((StructuredViewer)this.viewer).refresh(this.getModelObject(local), true);
            this.updateParentLabels(local);
            ++i;
        }
    }

    protected void handleResourceRemovals(SyncSetChangedEvent event) {
        IResource[] removed = event.getRemovedRoots();
        int i = 0;
        while (i < removed.length) {
            IResource resource = removed[i];
            ((StructuredViewer)this.viewer).refresh(this.getModelObject(resource));
            this.updateParentLabels(resource);
            ++i;
        }
    }

    protected void handleResourceAdditions(SyncSetChangedEvent event) {
        IResource[] added = event.getAddedRoots();
        int i = 0;
        while (i < added.length) {
            IResource resource = added[i];
            ((StructuredViewer)this.viewer).refresh(this.getModelObject((IResource)resource.getParent()));
            this.updateParentLabels(resource);
            ++i;
        }
    }

    public StructuredViewer getViewer() {
        return (StructuredViewer)this.viewer;
    }

    public Object[] members(IResource resource) {
        IResource[] resources = this.getSubscriberInput().getFilteredSyncSet().members(resource);
        Object[] result = new Object[resources.length];
        int i = 0;
        while (i < resources.length) {
            IResource child = resources[i];
            result[i] = this.getModelObject(child);
            ++i;
        }
        return result;
    }

    public static SyncInfo getSyncInfo(Object element) {
        if (element instanceof SyncInfo) {
            return (SyncInfo)element;
        }
        if (element instanceof SynchronizeViewNode) {
            SynchronizeViewNode syncResource = (SynchronizeViewNode)element;
            return syncResource.getSyncInfo();
        }
        throw new NullPointerException();
    }

    public static IResource getResource(Object obj) {
        if (obj instanceof SyncInfo) {
            return ((SyncInfo)obj).getLocal();
        }
        if (obj instanceof SynchronizeViewNode) {
            return ((SynchronizeViewNode)obj).getResource();
        }
        return null;
    }

    public static int getSyncKind(Object element) {
        SyncInfo info = SyncSetContentProvider.getSyncInfo(element);
        if (info != null) {
            return info.getKind();
        }
        return 0;
    }

    public Object getParent(Object object) {
        IResource resource = SyncSetContentProvider.getResource(object);
        if (resource == null) {
            return null;
        }
        IContainer parent = resource.getParent();
        return this.getModelObject((IResource)parent);
    }

    public Object getModelObject(IResource resource) {
        if (resource.getType() == 8) {
            return this.getSubscriberInput();
        }
        return new SynchronizeViewNode(this.getSubscriberInput(), resource);
    }

    protected Object[] getModelObjects(IResource[] resources) {
        Object[] result = new Object[resources.length];
        int i = 0;
        while (i < resources.length) {
            result[i] = this.getModelObject(resources[i]);
            ++i;
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateParentLabels() {
        try {
            this.getViewer().update(this.parentsToUpdate.toArray(new Object[this.parentsToUpdate.size()]), null);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.parentsToUpdate.clear();
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.parentsToUpdate.clear();
            return;
        }
    }

    protected void updateParentLabels(IResource resource) {
        IContainer parent = resource.getParent();
        while (parent.getType() != 8) {
            this.parentsToUpdate.add(this.getModelObject((IResource)parent));
            parent = parent.getParent();
        }
    }
}

