/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.views;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.team.core.subscribers.SyncInfo;
import org.eclipse.team.internal.ui.synchronize.sets.SubscriberInput;
import org.eclipse.team.internal.ui.synchronize.sets.SyncSetChangedEvent;
import org.eclipse.team.internal.ui.synchronize.views.CompressedFolder;
import org.eclipse.team.internal.ui.synchronize.views.SyncSetContentProvider;
import org.eclipse.team.internal.ui.synchronize.views.SyncSetTreeContentProvider;
import org.eclipse.team.internal.ui.synchronize.views.SynchronizeViewNode;

public class CompressedFolderContentProvider
extends SyncSetTreeContentProvider {
    protected void handleResourceAdditions(SyncSetChangedEvent event) {
        AbstractTreeViewer tree = this.getTreeViewer();
        if (tree != null) {
            IResource[] roots = event.getAddedRoots();
            this.refreshProjects(tree, roots);
        } else {
            super.handleResourceAdditions(event);
        }
    }

    protected void handleResourceRemovals(SyncSetChangedEvent event) {
        AbstractTreeViewer tree = this.getTreeViewer();
        if (tree != null) {
            IResource[] roots = event.getRemovedRoots();
            this.refreshProjects(tree, roots);
        } else {
            super.handleResourceRemovals(event);
        }
    }

    private void refreshProjects(AbstractTreeViewer tree, IResource[] roots) {
        if (roots.length == 0) {
            return;
        }
        HashSet<Object> projects = new HashSet<Object>();
        int i = 0;
        while (i < roots.length) {
            if (roots[i].getType() == 4) {
                tree.refresh();
                return;
            }
            projects.add(this.getModelObject((IResource)roots[i].getProject()));
            ++i;
        }
        Iterator iter = projects.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            tree.refresh(element);
        }
    }

    public Object getParent(Object element) {
        IResource resource;
        SyncInfo info;
        if (element instanceof CompressedFolder) {
            return this.getModelObject((IResource)SyncSetContentProvider.getResource(element).getProject());
        }
        Object parent = super.getParent(element);
        if (parent instanceof SynchronizeViewNode && (info = ((SynchronizeViewNode)parent).getSyncInfo()) == null && (resource = ((SynchronizeViewNode)parent).getResource()).getType() == 2) {
            return new CompressedFolder((SubscriberInput)this.viewer.getInput(), resource);
        }
        return parent;
    }

    public Object[] getChildren(Object element) {
        IResource resource = SyncSetContentProvider.getResource(element);
        if (resource != null) {
            if (resource.getType() == 4) {
                return this.getProjectChildren((IProject)resource);
            }
            if (resource.getType() == 2) {
                return this.getFolderChildren(resource);
            }
        }
        return super.getChildren(element);
    }

    private Object[] getFolderChildren(IResource resource) {
        IResource[] children = this.getSyncSet().members(resource);
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < children.length) {
            IResource child = children[i];
            SyncInfo info = this.getSyncSet().getSyncInfo(child);
            if (info != null) {
                result.add(this.getModelObject(info.getLocal()));
            }
            ++i;
        }
        return result.toArray(new Object[result.size()]);
    }

    private Object[] getProjectChildren(IProject project) {
        SyncInfo[] outOfSync = this.getSyncSet().getOutOfSyncDescendants((IResource)project);
        HashSet<Object> result = new HashSet<Object>();
        int i = 0;
        while (i < outOfSync.length) {
            SyncInfo info = outOfSync[i];
            IResource local = info.getLocal();
            if (local.getProjectRelativePath().segmentCount() == 1) {
                result.add(this.getModelObject(local));
            } else {
                IContainer container = this.getLowestInSyncParent(local);
                if (container.getType() == 2) {
                    result.add(this.getModelObject((IResource)container));
                }
            }
            ++i;
        }
        return result.toArray(new Object[result.size()]);
    }

    public Object getModelObject(IResource resource) {
        if (resource.getType() == 2 && this.getSyncSet().getSyncInfo(resource) == null) {
            return new CompressedFolder(this.getSubscriberInput(), resource);
        }
        return super.getModelObject(resource);
    }

    private IContainer getLowestInSyncParent(IResource resource) {
        if (resource.getType() == 8) {
            return (IContainer)resource;
        }
        IContainer parent = resource.getParent();
        if (this.getSyncSet().getSyncInfo((IResource)parent) == null) {
            return parent;
        }
        return this.getLowestInSyncParent((IResource)parent);
    }
}

