/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.sets;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.SyncInfo;
import org.eclipse.team.internal.ui.synchronize.sets.ISyncSetChangedListener;
import org.eclipse.team.internal.ui.synchronize.sets.SyncSet;
import org.eclipse.team.internal.ui.synchronize.sets.SyncSetChangedEvent;
import org.eclipse.team.internal.ui.synchronize.sets.SyncSetInput;

public class SyncSetInputFromSyncSet
extends SyncSetInput
implements ISyncSetChangedListener {
    SyncSet inputSyncSet;

    public SyncSetInputFromSyncSet(SyncSet set) {
        this.inputSyncSet = set;
        this.inputSyncSet.addSyncSetChangedListener(this);
    }

    public SyncSet getInputSyncSet() {
        return this.inputSyncSet;
    }

    public void disconnect() {
        if (this.inputSyncSet == null) {
            return;
        }
        this.inputSyncSet.removeSyncSetChangedListener(this);
        this.inputSyncSet = null;
    }

    protected void fetchInput(IProgressMonitor monitor) throws TeamException {
        if (this.inputSyncSet == null) {
            return;
        }
        SyncInfo[] infos = this.inputSyncSet.allMembers();
        int i = 0;
        while (i < infos.length) {
            this.collect(infos[i]);
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void syncSetChanged(SyncSetChangedEvent event) {
        SyncSet syncSet = this.getSyncSet();
        try {
            syncSet.beginInput();
            if (event.isReset()) {
                syncSet.reset();
            }
            this.syncSetChanged(event.getChangedResources());
            this.syncSetChanged(event.getAddedResources());
            this.remove(event.getRemovedResources());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.getSyncSet().endInput();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.getSyncSet().endInput();
            return;
        }
    }

    private void syncSetChanged(SyncInfo[] infos) {
        int i = 0;
        while (i < infos.length) {
            this.collect(infos[i]);
            ++i;
        }
    }

    private void remove(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            this.remove(resources[i]);
            ++i;
        }
    }
}

