/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.sets;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.SyncInfo;
import org.eclipse.team.internal.ui.synchronize.sets.SyncSet;
import org.eclipse.team.ui.synchronize.actions.SyncInfoFilter;

public abstract class SyncSetInput {
    private SyncSet syncSet = new SyncSet();
    private SyncInfoFilter filter = new SyncInfoFilter();

    public SyncSet getSyncSet() {
        return this.syncSet;
    }

    protected abstract void fetchInput(IProgressMonitor var1) throws TeamException;

    public abstract void disconnect();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reset(IProgressMonitor monitor) throws TeamException {
        try {
            this.syncSet.beginInput();
            this.syncSet.reset();
            this.fetchInput(monitor);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.getSyncSet().endInput();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.getSyncSet().endInput();
            return;
        }
    }

    protected void collect(SyncInfo info) {
        boolean wasOutOfSync;
        boolean isOutOfSync = this.filter.select(info);
        SyncInfo oldInfo = this.syncSet.getSyncInfo(info.getLocal());
        boolean bl = wasOutOfSync = oldInfo != null;
        if (isOutOfSync) {
            if (wasOutOfSync) {
                this.syncSet.changed(info);
            } else {
                this.syncSet.add(info);
            }
        } else if (wasOutOfSync) {
            this.syncSet.remove(info.getLocal());
        }
    }

    protected void remove(IResource resource) {
        SyncInfo oldInfo = this.syncSet.getSyncInfo(resource);
        boolean bl = oldInfo != null;
        if (oldInfo != null) {
            this.syncSet.remove(resource);
        }
    }

    public SyncInfoFilter getFilter() {
        return this.filter;
    }

    public void setFilter(SyncInfoFilter filter) {
        this.filter = filter;
    }
}

