/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.sets;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.subscribers.SyncInfo;
import org.eclipse.team.internal.ui.synchronize.sets.SyncSet;

public class SyncSetChangedEvent {
    private SyncSet set;
    private Set changedResources = new HashSet();
    private Set removedResources = new HashSet();
    private Set addedResources = new HashSet();
    private Set removedRoots = new HashSet();
    private Set addedRoots = new HashSet();
    private boolean reset = false;

    public SyncSetChangedEvent(SyncSet set) {
        this.set = set;
    }

    void added(SyncInfo info) {
        this.addedResources.add(info);
    }

    void removed(IResource resource) {
        this.removedResources.add(resource);
    }

    void changed(SyncInfo info) {
        this.changedResources.add(info);
    }

    public void removedRoot(IResource root) {
        if (this.addedRoots.contains(root)) {
            this.addedRoots.remove(root);
        } else {
            Iterator iter = this.removedRoots.iterator();
            while (iter.hasNext()) {
                IResource element = (IResource)iter.next();
                if (root.equals((Object)element)) {
                    return;
                }
                if (this.isParent(root, element)) {
                    iter.remove();
                    continue;
                }
                if (!this.isParent(element, root)) continue;
                return;
            }
            this.removedRoots.add(root);
        }
    }

    private boolean isParent(IResource root, IResource element) {
        return root.getFullPath().isPrefixOf(element.getFullPath());
    }

    public void addedRoot(IResource parent) {
        if (this.removedRoots.contains(parent)) {
            this.removedRoots.remove(parent);
        } else {
            this.addedRoots.add(parent);
        }
    }

    public SyncInfo[] getAddedResources() {
        return this.addedResources.toArray(new SyncInfo[this.addedResources.size()]);
    }

    public IResource[] getAddedRoots() {
        return this.addedRoots.toArray(new IResource[this.addedRoots.size()]);
    }

    public SyncInfo[] getChangedResources() {
        return this.changedResources.toArray(new SyncInfo[this.changedResources.size()]);
    }

    public IResource[] getRemovedResources() {
        return this.removedResources.toArray(new IResource[this.removedResources.size()]);
    }

    public IResource[] getRemovedRoots() {
        return this.removedRoots.toArray(new IResource[this.removedRoots.size()]);
    }

    public SyncSet getSet() {
        return this.set;
    }

    public void reset() {
        this.reset = true;
    }

    public boolean isReset() {
        return this.reset;
    }

    public boolean isEmpty() {
        return this.changedResources.isEmpty() && this.removedResources.isEmpty() && this.addedResources.isEmpty() && this.removedRoots.isEmpty() && this.addedRoots.isEmpty();
    }
}

