/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.sets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.core.subscribers.SyncInfo;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.synchronize.sets.ISyncSetChangedListener;
import org.eclipse.team.internal.ui.synchronize.sets.SyncInfoStatistics;
import org.eclipse.team.internal.ui.synchronize.sets.SyncSetChangedEvent;

public class SyncSet {
    protected Map resources = Collections.synchronizedMap(new HashMap());
    protected Map parents = Collections.synchronizedMap(new HashMap());
    protected SyncSetChangedEvent changes;
    protected Set listeners = Collections.synchronizedSet(new HashSet());
    protected SyncInfoStatistics statistics = new SyncInfoStatistics();

    public SyncSet() {
        this.resetChanges();
    }

    private void resetChanges() {
        this.changes = new SyncSetChangedEvent(this);
    }

    private void fireChanges() {
        ISyncSetChangedListener[] allListeners;
        SyncSetChangedEvent event;
        SyncSet syncSet = this;
        synchronized (syncSet) {
            event = this.changes;
            this.resetChanges();
        }
        if (event.isEmpty() && !event.isReset()) {
            return;
        }
        Set set = this.listeners;
        synchronized (set) {
            allListeners = this.listeners.toArray(new ISyncSetChangedListener[this.listeners.size()]);
        }
        int i = 0;
        while (i < allListeners.length) {
            final ISyncSetChangedListener listener = allListeners[i];
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.syncSetChanged(event);
                }
            });
            ++i;
        }
    }

    public void addSyncSetChangedListener(ISyncSetChangedListener listener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    public void removeSyncSetChangedListener(ISyncSetChangedListener listener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    public synchronized void add(SyncInfo info) {
        this.internalAddSyncInfo(info);
        this.changes.added(info);
        IResource local = info.getLocal();
        this.addToParents(local, local);
    }

    private void internalAddSyncInfo(SyncInfo info) {
        IResource local = info.getLocal();
        IPath path = local.getFullPath();
        SyncInfo oldSyncInfo = this.resources.put(path, info);
        if (oldSyncInfo == null) {
            this.statistics.add(info);
        } else {
            this.statistics.remove(oldSyncInfo);
            this.statistics.add(info);
        }
    }

    protected synchronized void remove(IResource local) {
        IPath path = local.getFullPath();
        SyncInfo info = (SyncInfo)this.resources.remove(path);
        this.changes.removed(local);
        this.statistics.remove(info);
        this.removeFromParents(local, local);
    }

    protected synchronized void changed(SyncInfo info) {
        this.internalAddSyncInfo(info);
        this.changes.changed(info);
    }

    public synchronized void reset() {
        this.resources.clear();
        this.parents.clear();
        this.changes.reset();
        this.statistics.clear();
    }

    private boolean addToParents(IResource resource, IResource parent) {
        if (parent.getType() == 8) {
            return false;
        }
        boolean addedParent = false;
        if (parent.getType() == 1) {
            addedParent = true;
        } else {
            HashSet<IResource> children = (HashSet<IResource>)this.parents.get(parent.getFullPath());
            if (children == null) {
                children = new HashSet<IResource>();
                this.parents.put(parent.getFullPath(), children);
                addedParent = true;
            }
            children.add(resource);
        }
        if (!this.addToParents(resource, (IResource)parent.getParent()) && addedParent) {
            this.changes.addedRoot(parent);
        }
        return addedParent;
    }

    private boolean removeFromParents(IResource resource, IResource parent) {
        if (parent.getType() == 8) {
            return false;
        }
        boolean removedParent = false;
        if (parent.getType() == 1) {
            removedParent = true;
        } else {
            Set children = (Set)this.parents.get(parent.getFullPath());
            if (children != null) {
                children.remove(resource);
                if (children.isEmpty()) {
                    this.parents.remove(parent.getFullPath());
                    removedParent = true;
                }
            }
        }
        if (!this.removeFromParents(resource, (IResource)parent.getParent()) && removedParent) {
            this.changes.removedRoot(parent);
        }
        return removedParent;
    }

    public synchronized IResource[] members(IResource resource) {
        if (resource.getType() == 1) {
            return new IResource[0];
        }
        IContainer parent = (IContainer)resource;
        if (parent.getType() == 8) {
            return this.getRoots(parent);
        }
        HashSet<IResource> children = new HashSet<IResource>();
        IPath path = parent.getFullPath();
        Set possibleChildren = (Set)this.parents.get(path);
        if (possibleChildren != null) {
            Iterator it = possibleChildren.iterator();
            while (it.hasNext()) {
                Object next = it.next();
                IResource element = (IResource)next;
                IPath childPath = element.getFullPath();
                IResource modelObject = null;
                if (childPath.segmentCount() == path.segmentCount() + 1) {
                    modelObject = element;
                } else if (childPath.segmentCount() > path.segmentCount()) {
                    IFolder childFolder = parent.getFolder((IPath)new Path(childPath.segment(path.segmentCount())));
                    modelObject = childFolder;
                }
                if (modelObject == null) continue;
                children.add(modelObject);
            }
        }
        return children.toArray(new IResource[children.size()]);
    }

    public synchronized SyncInfo[] getOutOfSyncDescendants(IResource resource) {
        if (resource.getType() == 1) {
            SyncInfo info = this.getSyncInfo(resource);
            if (info == null) {
                return new SyncInfo[0];
            }
            return new SyncInfo[]{info};
        }
        IContainer container = (IContainer)resource;
        IPath path = container.getFullPath();
        Set children = (Set)this.parents.get(path);
        if (children == null) {
            return new SyncInfo[0];
        }
        ArrayList<SyncInfo> infos = new ArrayList<SyncInfo>();
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            IResource child = (IResource)iter.next();
            SyncInfo info = this.getSyncInfo(child);
            if (info != null) {
                infos.add(info);
                continue;
            }
            TeamUIPlugin.log(1, "missing sync info: " + child.getFullPath(), null);
        }
        return infos.toArray(new SyncInfo[infos.size()]);
    }

    private IResource[] getRoots(IContainer root) {
        Set possibleChildren = this.parents.keySet();
        HashSet<IProject> children = new HashSet<IProject>();
        Iterator it = possibleChildren.iterator();
        while (it.hasNext()) {
            Object next = it.next();
            IResource element = ((IWorkspaceRoot)root).findMember((IPath)next);
            if (element == null) continue;
            children.add(element.getProject());
        }
        return children.toArray(new IResource[children.size()]);
    }

    public synchronized SyncInfo[] allMembers() {
        return this.resources.values().toArray(new SyncInfo[this.resources.size()]);
    }

    protected synchronized void removeAllChildren(IResource resource) {
        Set allChildren = (Set)this.parents.get(resource.getFullPath());
        if (allChildren == null) {
            return;
        }
        IResource[] removed = allChildren.toArray(new IResource[allChildren.size()]);
        int i = 0;
        while (i < removed.length) {
            this.remove(removed[i]);
            ++i;
        }
    }

    public synchronized SyncInfo getSyncInfo(IResource resource) {
        return (SyncInfo)this.resources.get(resource.getFullPath());
    }

    void beginInput() {
        SyncSet syncSet = this;
        synchronized (syncSet) {
            this.resetChanges();
        }
    }

    void endInput() {
        this.fireChanges();
    }

    public int size() {
        return this.resources.size();
    }

    public SyncInfoStatistics getStatistics() {
        return this.statistics;
    }

    public boolean hasMembers(IResource resource) {
        if (resource.getType() == 1) {
            return false;
        }
        IContainer parent = (IContainer)resource;
        if (parent.getType() == 8) {
            return !this.resources.isEmpty();
        }
        IPath path = parent.getFullPath();
        Set allDescendants = (Set)this.parents.get(path);
        return allDescendants != null && !allDescendants.isEmpty();
    }
}

