/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.sets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.SyncInfo;
import org.eclipse.team.core.subscribers.TeamSubscriber;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.ui.synchronize.actions.SyncInfoFilter;
import org.eclipse.ui.IWorkingSet;

public class SyncInfoWorkingSetFilter
extends SyncInfoFilter {
    private IWorkingSet workingSet;
    static /* synthetic */ Class class$0;

    public boolean select(SyncInfo info) {
        if (this.workingSet == null) {
            return true;
        }
        return this.isIncluded(info.getLocal());
    }

    private boolean isIncluded(IResource resource) {
        IAdaptable[] elements = this.workingSet.getElements();
        new ArrayList();
        int i = 0;
        while (i < elements.length) {
            IResource setResource = this.getResource(elements[i]);
            if (this.isParent(setResource, resource)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IResource getResource(Object object) {
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.core.resources.IResource;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IResource)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    private boolean isParent(IResource parent, IResource child) {
        return parent.getFullPath().isPrefixOf(child.getFullPath());
    }

    public IWorkingSet getWorkingSet() {
        return this.workingSet;
    }

    public IResource[] getRoots(TeamSubscriber subscriber) {
        IResource[] roots = subscriber.roots();
        if (this.workingSet == null) {
            return roots;
        }
        HashSet<IResource> result = new HashSet<IResource>();
        int i = 0;
        while (i < roots.length) {
            IResource resource = roots[i];
            result.addAll(Arrays.asList(this.getIntersectionWithSet(subscriber, resource)));
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    private IResource[] getIntersectionWithSet(TeamSubscriber subscriber, IResource resource) {
        IAdaptable[] elements = this.workingSet.getElements();
        ArrayList<IResource> result = new ArrayList<IResource>();
        int i = 0;
        while (i < elements.length) {
            IResource setResource = this.getResource(elements[i]);
            if (setResource != null) {
                if (this.isParent(resource, setResource)) {
                    try {
                        if (subscriber.isSupervised(setResource)) {
                            result.add(setResource);
                        }
                    }
                    catch (TeamException e) {
                        TeamUIPlugin.log((CoreException)((Object)e));
                        result.add(setResource);
                    }
                } else if (this.isParent(setResource, resource)) {
                    result.add(resource);
                }
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public void setWorkingSet(IWorkingSet workingSet) {
        this.workingSet = workingSet;
    }
}

