/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.sets;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.ITeamResourceChangeListener;
import org.eclipse.team.core.subscribers.TeamDelta;
import org.eclipse.team.core.subscribers.TeamSubscriber;
import org.eclipse.team.internal.core.Assert;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.synchronize.sets.ISyncSetChangedListener;
import org.eclipse.team.internal.ui.synchronize.sets.SubscriberEventHandler;
import org.eclipse.team.internal.ui.synchronize.sets.SyncSet;
import org.eclipse.team.internal.ui.synchronize.sets.SyncSetInputFromSubscriber;
import org.eclipse.team.internal.ui.synchronize.sets.SyncSetInputFromSyncSet;
import org.eclipse.team.internal.ui.synchronize.sets.WorkingSetSyncSetInput;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.TeamSubscriberParticipant;
import org.eclipse.team.ui.synchronize.actions.SyncInfoFilter;
import org.eclipse.ui.IWorkingSet;

public class SubscriberInput
implements IPropertyChangeListener,
ITeamResourceChangeListener,
IResourceChangeListener {
    private SyncSetInputFromSubscriber subscriberSyncSet;
    private WorkingSetSyncSetInput workingRootsSet;
    private SyncSetInputFromSyncSet filteredSyncSet;
    private SubscriberEventHandler eventHandler;
    private TeamSubscriberParticipant participant;

    public SubscriberInput(TeamSubscriberParticipant participant, TeamSubscriber subscriber) {
        this.participant = participant;
        Assert.isNotNull((Object)subscriber);
        this.subscriberSyncSet = new SyncSetInputFromSubscriber(subscriber);
        this.workingRootsSet = new WorkingSetSyncSetInput(this.subscriberSyncSet.getSyncSet());
        this.filteredSyncSet = new SyncSetInputFromSyncSet(this.workingRootsSet.getSyncSet());
        this.eventHandler = new SubscriberEventHandler(this.subscriberSyncSet);
        TeamUI.addPropertyChangeListener(this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        subscriber.addListener((ITeamResourceChangeListener)this);
    }

    public TeamSubscriber getSubscriber() {
        return this.subscriberSyncSet.getSubscriber();
    }

    public TeamSubscriberParticipant getParticipant() {
        return this.participant;
    }

    public SyncSet getFilteredSyncSet() {
        return this.filteredSyncSet.getSyncSet();
    }

    public SyncSet getSubscriberSyncSet() {
        return this.subscriberSyncSet.getSyncSet();
    }

    public SyncSet getWorkingSetSyncSet() {
        return this.workingRootsSet.getSyncSet();
    }

    public SubscriberEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void setFilter(SyncInfoFilter filter, IProgressMonitor monitor) throws TeamException {
        this.filteredSyncSet.setFilter(filter);
        this.filteredSyncSet.reset(monitor);
    }

    public void setWorkingSet(IWorkingSet set) {
        this.workingRootsSet.setWorkingSet(set);
    }

    public IWorkingSet getWorkingSet() {
        return this.workingRootsSet.getWorkingSet();
    }

    public void dispose() {
        this.eventHandler.shutdown();
        this.filteredSyncSet.disconnect();
        this.workingRootsSet.disconnect();
        this.subscriberSyncSet.disconnect();
        this.getSubscriber().removeListener((ITeamResourceChangeListener)this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        TeamUI.removePropertyChangeListener(this);
    }

    public IResource[] workingSetRoots() {
        return this.workingRootsSet.roots(this.getSubscriber());
    }

    public IResource[] subscriberRoots() {
        return this.getSubscriber().roots();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(TeamUI.GLOBAL_IGNORES_CHANGED)) {
            try {
                this.reset();
            }
            catch (TeamException e) {
                TeamUIPlugin.log((CoreException)((Object)e));
            }
        }
    }

    public void reset() throws TeamException {
        this.subscriberSyncSet.reset((IProgressMonitor)new NullProgressMonitor());
        this.workingRootsSet.reset((IProgressMonitor)new NullProgressMonitor());
        this.filteredSyncSet.reset((IProgressMonitor)new NullProgressMonitor());
        this.eventHandler.initialize();
    }

    private void processDelta(IResourceDelta delta) {
        int changeFlags;
        IResource resource = delta.getResource();
        int kind = delta.getKind();
        if (resource.getType() == 4) {
            if ((kind & 2) != 0) {
                this.eventHandler.remove(resource);
                return;
            }
            if ((delta.getFlags() & 0x4000) != 0 && !((IProject)resource).isOpen()) {
                this.eventHandler.remove(resource);
                return;
            }
            if (!this.isVisibleProject((IProject)resource)) {
                if (this.getSubscriberSyncSet().hasMembers(resource)) {
                    this.eventHandler.remove(resource);
                }
                return;
            }
        }
        if ((delta.getFlags() & 0x8000) != 0) {
            this.eventHandler.remove(resource);
            this.eventHandler.change(resource, 2);
        }
        if (((changeFlags = delta.getFlags()) & 0x4100) != 0) {
            this.eventHandler.change(resource, 0);
        }
        if ((delta.getKind() & 3) != 0) {
            this.eventHandler.change(resource, 0);
        }
        IResourceDelta[] affectedChildren = delta.getAffectedChildren(7);
        int i = 0;
        while (i < affectedChildren.length) {
            this.processDelta(affectedChildren[i]);
            ++i;
        }
    }

    private boolean isVisibleProject(IProject project) {
        IResource[] roots = this.subscriberRoots();
        int i = 0;
        while (i < roots.length) {
            IResource resource = roots[i];
            if (project.getFullPath().isPrefixOf(resource.getFullPath())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.processDelta(event.getDelta());
    }

    public void teamResourceChanged(TeamDelta[] deltas) {
        int i = 0;
        while (i < deltas.length) {
            switch (deltas[i].getFlags()) {
                case 1: {
                    this.eventHandler.change(deltas[i].getResource(), 0);
                    break;
                }
                case 4: {
                    this.eventHandler.remove(deltas[i].getResource());
                    break;
                }
                case 2: {
                    this.eventHandler.change(deltas[i].getResource(), 2);
                }
            }
            ++i;
        }
    }

    public void registerListeners(ISyncSetChangedListener listener) {
        this.getWorkingSetSyncSet().addSyncSetChangedListener(listener);
        this.getFilteredSyncSet().addSyncSetChangedListener(listener);
        this.getSubscriberSyncSet().addSyncSetChangedListener(listener);
    }

    public void deregisterListeners(ISyncSetChangedListener listener) {
        this.getWorkingSetSyncSet().removeSyncSetChangedListener(listener);
        this.getFilteredSyncSet().removeSyncSetChangedListener(listener);
        this.getSubscriberSyncSet().removeSyncSetChangedListener(listener);
    }
}

