/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.sets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.BackgroundEventHandler;
import org.eclipse.team.core.subscribers.SyncInfo;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.jobs.JobStatusHandler;
import org.eclipse.team.internal.ui.synchronize.sets.SyncSetInputFromSubscriber;
import org.eclipse.team.ui.synchronize.actions.SubscriberAction;

public class SubscriberEventHandler
extends BackgroundEventHandler {
    private SyncSetInputFromSubscriber set;
    private List resultCache = new ArrayList();

    public SubscriberEventHandler(SyncSetInputFromSubscriber set) {
        this.set = set;
        this.reset(3);
    }

    public void schedule() {
        JobStatusHandler.schedule(this.getEventHandlerJob(), SubscriberAction.SUBSCRIBER_JOB_TYPE);
    }

    public void initialize() {
        this.reset(2);
    }

    public void change(IResource resource, int depth) {
        this.queueEvent(new SubscriberEvent(resource, 2, depth));
    }

    public void remove(IResource resource) {
        this.queueEvent(new SubscriberEvent(resource, 1, 2));
    }

    private void collect(IResource resource, int depth, IProgressMonitor monitor, List results) throws TeamException {
        if (resource.getType() != 1 && depth != 0) {
            IResource[] members = this.set.getSubscriber().members(resource);
            int i = 0;
            while (i < members.length) {
                this.collect(members[i], depth == 2 ? 2 : 0, monitor, results);
                ++i;
            }
        }
        monitor.subTask(Policy.bind("SubscriberEventHandler.2", resource.getFullPath().toString()));
        SyncInfo info = this.set.getSubscriber().getSyncInfo(resource, monitor);
        if (info == null) {
            results.add(new SubscriberEvent(resource, 1, 0));
        } else {
            results.add(new SubscriberEvent(resource, 2, 0, info));
        }
        monitor.worked(1);
    }

    private SubscriberEvent[] getAllOutOfSync(IResource[] resources, int depth, IProgressMonitor monitor) throws TeamException {
        SubscriberEvent[] subscriberEventArray;
        SyncInfo[] infos;
        block5: {
            monitor.beginTask(null, 100);
            infos = this.set.getSubscriber().getAllOutOfSync(resources, depth, Policy.subMonitorFor(monitor, 50));
            if (infos != null) break block5;
            ArrayList events = new ArrayList();
            IProgressMonitor subMonitor = Policy.subInfiniteMonitorFor(monitor, 50);
            subMonitor.beginTask(null, resources.length);
            int i = 0;
            while (i < resources.length) {
                this.collect(resources[i], 2, subMonitor, events);
                ++i;
            }
            SubscriberEvent[] subscriberEventArray2 = events.toArray(new SubscriberEvent[events.size()]);
            Object var8_13 = null;
            monitor.done();
            return subscriberEventArray2;
        }
        try {
            SubscriberEvent[] events = new SubscriberEvent[infos.length];
            int i = 0;
            while (i < infos.length) {
                SyncInfo info = infos[i];
                events[i] = new SubscriberEvent(info.getLocal(), 2, depth, info);
                ++i;
            }
            subscriberEventArray = events;
            Object var8_14 = null;
        }
        catch (Throwable throwable) {
            Object var8_15 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return subscriberEventArray;
    }

    private void dispatchEvents(SubscriberEvent[] events) {
        this.set.getSyncSet().beginInput();
        int i = 0;
        while (i < events.length) {
            SubscriberEvent event = events[i];
            switch (event.getType()) {
                case 2: {
                    this.set.collect(event.getResult());
                    break;
                }
                case 1: {
                    if (event.getDepth() == 2) {
                        this.set.getSyncSet().removeAllChildren(event.getResource());
                        break;
                    }
                    this.set.remove(event.getResource());
                }
            }
            ++i;
        }
        this.set.getSyncSet().endInput();
    }

    private void reset(int type) {
        IResource[] resources = this.set.getSubscriber().roots();
        int i = 0;
        while (i < resources.length) {
            this.queueEvent(new SubscriberEvent(resources[i], type, 2));
            ++i;
        }
    }

    public String getName() {
        return Policy.bind("SubscriberEventHandler.jobName");
    }

    public String getErrorsTitle() {
        return Policy.bind("SubscriberEventHandler.errors");
    }

    protected void processEvent(BackgroundEventHandler.Event event, IProgressMonitor monitor) throws TeamException {
        int type = event.getType();
        switch (type) {
            case 1: {
                this.resultCache.add(event);
                break;
            }
            case 2: {
                ArrayList results = new ArrayList();
                this.collect(event.getResource(), event.getDepth(), monitor, results);
                this.resultCache.addAll(results);
                break;
            }
            case 3: {
                monitor.subTask(Policy.bind("SubscriberEventHandler.2", event.getResource().getFullPath().toString()));
                SubscriberEvent[] events = this.getAllOutOfSync(new IResource[]{event.getResource()}, event.getDepth(), Policy.subMonitorFor(monitor, 64));
                this.resultCache.addAll(Arrays.asList(events));
            }
        }
    }

    protected void dispatchEvents() {
        this.dispatchEvents(this.resultCache.toArray(new SubscriberEvent[this.resultCache.size()]));
        this.resultCache.clear();
    }

    class SubscriberEvent
    extends BackgroundEventHandler.Event {
        static final int REMOVAL = 1;
        static final int CHANGE = 2;
        static final int INITIALIZE = 3;
        SyncInfo result;

        SubscriberEvent(IResource resource, int type, int depth) {
            super(resource, type, depth);
        }

        public SubscriberEvent(IResource resource, int type, int depth, SyncInfo result) {
            this(resource, type, depth);
            this.result = result;
        }

        public SyncInfo getResult() {
            return this.result;
        }

        protected String getTypeString() {
            switch (this.getType()) {
                case 1: {
                    return "REMOVAL";
                }
                case 2: {
                    return "CHANGE";
                }
                case 3: {
                    return "INITIALIZE";
                }
            }
            return "INVALID";
        }
    }
}

