/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.compare;

import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.SyncInfo;
import org.eclipse.team.core.sync.IRemoteResource;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.synchronize.compare.LocalResourceTypedElement;
import org.eclipse.team.internal.ui.synchronize.compare.RemoteResourceTypedElement;

public class SyncInfoDiffNode
extends DiffNode {
    public static ITypedElement createTypeElement(IResource resource, final int kind) {
        if (resource != null && resource.exists()) {
            return new LocalResourceTypedElement(resource){

                public boolean isEditable() {
                    if (SyncInfo.getDirection((int)kind) == 4 && SyncInfo.getChange((int)kind) == 2) {
                        return false;
                    }
                    return super.isEditable();
                }
            };
        }
        return null;
    }

    public static ITypedElement createTypeElement(IRemoteResource remoteResource) {
        return new RemoteResourceTypedElement(remoteResource);
    }

    public SyncInfoDiffNode(ITypedElement base, ITypedElement local, ITypedElement remote, int syncKind) {
        super(syncKind, base, local, remote);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cacheContents(IProgressMonitor monitor) throws TeamException {
        ITypedElement base = this.getAncestor();
        ITypedElement remote = this.getRight();
        int work = Math.min((remote == null ? 0 : 50) + (base == null ? 0 : 50), 10);
        monitor.beginTask(null, work);
        try {
            if (base != null && base instanceof RemoteResourceTypedElement) {
                ((RemoteResourceTypedElement)base).cacheContents(Policy.subMonitorFor(monitor, 50));
            }
            if (remote != null && remote instanceof RemoteResourceTypedElement) {
                ((RemoteResourceTypedElement)remote).cacheContents(Policy.subMonitorFor(monitor, 50));
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
    }
}

