/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.compare;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.SyncInfo;
import org.eclipse.team.core.sync.IRemoteResource;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.synchronize.compare.LocalResourceTypedElement;
import org.eclipse.team.internal.ui.synchronize.compare.SyncInfoDiffNode;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;

public class SyncInfoCompareInput
extends CompareEditorInput {
    private SyncInfo sync;
    private SyncInfoDiffNode node;
    private static Image titleImage;
    private static ISynchronizeParticipant participant;

    public static SyncInfoCompareInput createInput(ISynchronizeParticipant participant, SyncInfo sync) {
        SyncInfoCompareInput.participant = participant;
        ITypedElement localTypedElement = SyncInfoDiffNode.createTypeElement(sync.getLocal(), sync.getKind());
        ITypedElement remoteTypedElement = null;
        IRemoteResource remoteResource = sync.getRemote();
        if (remoteResource != null) {
            remoteTypedElement = SyncInfoDiffNode.createTypeElement(remoteResource);
        }
        ITypedElement baseTypedElement = null;
        IRemoteResource baseResource = sync.getBase();
        if (baseResource != null) {
            baseTypedElement = SyncInfoDiffNode.createTypeElement(baseResource);
        }
        return new SyncInfoCompareInput(sync, new SyncInfoDiffNode(baseTypedElement, localTypedElement, remoteTypedElement, sync.getKind()));
    }

    private SyncInfoCompareInput(SyncInfo sync, SyncInfoDiffNode diffNode) {
        super(new CompareConfiguration());
        this.sync = sync;
        this.node = diffNode;
        this.initializeContentChangeListeners();
    }

    private void initializeContentChangeListeners() {
        ITypedElement te = this.node.getLeft();
        if (te instanceof IContentChangeNotifier) {
            ((IContentChangeNotifier)te).addContentChangeListener(new IContentChangeListener(){

                public void contentChanged(IContentChangeNotifier source) {
                    try {
                        SyncInfoCompareInput.this.saveChanges((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException coreException) {}
                }
            });
        }
    }

    public Image getTitleImage() {
        if (titleImage == null) {
            titleImage = TeamUIPlugin.getImageDescriptor("cview16/synch_synch.gif").createImage();
            TeamUIPlugin.disposeOnShutdown(titleImage);
        }
        return titleImage;
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.setTitle(this.getTitle());
        this.updateLabels();
        try {
            this.node.cacheContents(monitor);
        }
        catch (TeamException e) {
            throw new InvocationTargetException(e);
        }
        return this.node;
    }

    public String getTitle() {
        return Policy.bind("SyncInfoCompareInput.title", participant.getName(), this.node.getName());
    }

    protected void updateLabels() {
        CompareConfiguration config = this.getCompareConfiguration();
        IRemoteResource remote = this.sync.getRemote();
        IRemoteResource base = this.sync.getBase();
        String localContentId = this.sync.getLocalContentIdentifier();
        if (localContentId != null) {
            config.setLeftLabel(Policy.bind("SyncInfoCompareInput.localLabelExists", localContentId));
        } else {
            config.setLeftLabel(Policy.bind("SyncInfoCompareInput.localLabel"));
        }
        if (remote != null) {
            try {
                config.setRightLabel(Policy.bind("SyncInfoCompareInput.remoteLabelExists", remote.getContentIdentifier()));
            }
            catch (TeamException teamException) {
                config.setRightLabel(Policy.bind("SyncInfoCompareInput.remoteLabel"));
            }
        } else {
            config.setRightLabel(Policy.bind("SyncInfoCompareInput.remoteLabel"));
        }
        if (base != null) {
            try {
                config.setAncestorLabel(Policy.bind("SyncInfoCompareInput.baseLabelExists", base.getContentIdentifier()));
            }
            catch (TeamException teamException) {
                config.setAncestorLabel(Policy.bind("SyncInfoCompareInput.baseLabel"));
            }
        } else {
            config.setAncestorLabel(Policy.bind("SyncInfoCompareInput.baseLabel"));
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return TeamUIPlugin.getImageDescriptor("clcl16/catchuprelease_rls.gif");
    }

    public String getToolTipText() {
        return Policy.bind("SyncInfoCompareInput.tooltip", participant.getName(), this.node.getName());
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof SyncInfoCompareInput) {
            return this.getSyncInfo().equals((Object)((SyncInfoCompareInput)((Object)other)).getSyncInfo());
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveChanges(IProgressMonitor pm) throws CoreException {
        super.saveChanges(pm);
        if (this.node == null) return;
        try {
            SyncInfoCompareInput.commit(pm, this.node);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.setDirty(false);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.setDirty(false);
    }

    private static void commit(IProgressMonitor pm, DiffNode node) throws CoreException {
        ITypedElement right;
        ITypedElement left = node.getLeft();
        if (left instanceof LocalResourceTypedElement) {
            ((LocalResourceTypedElement)left).commit(pm);
        }
        if ((right = node.getRight()) instanceof LocalResourceTypedElement) {
            ((LocalResourceTypedElement)right).commit(pm);
        }
    }

    public SyncInfo getSyncInfo() {
        return this.sync;
    }
}

