/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.compare;

import java.io.InputStream;
import org.eclipse.compare.BufferedContent;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.sync.IRemoteResource;

public class RemoteResourceTypedElement
extends BufferedContent
implements ITypedElement,
IEditableContent {
    private IRemoteResource remote;
    private IStorage bufferedContents;

    RemoteResourceTypedElement(IRemoteResource remote) {
        this.remote = remote;
    }

    public Image getImage() {
        return CompareUI.getImage((String)this.getType());
    }

    public String getName() {
        return this.remote.getName();
    }

    public String getType() {
        if (this.remote.isContainer()) {
            return "FOLDER";
        }
        String name = this.getName();
        if (name != null) {
            int index = name.lastIndexOf(46);
            if (index == -1) {
                return "";
            }
            if (index == name.length() - 1) {
                return "";
            }
            return name.substring(index + 1);
        }
        return "FOLDER";
    }

    public boolean isEditable() {
        return false;
    }

    public ITypedElement replace(ITypedElement child, ITypedElement other) {
        return null;
    }

    protected InputStream createStream() throws CoreException {
        if (this.bufferedContents != null) {
            return this.bufferedContents.getContents();
        }
        return null;
    }

    public IRemoteResource getRemote() {
        return this.remote;
    }

    public void cacheContents(IProgressMonitor monitor) throws TeamException {
        this.bufferedContents = this.remote.getBufferedStorage(monitor);
    }
}

