/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.team.internal.ui.synchronize.actions.WorkingSetFilterActionGroup;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkingSetComparator;

public class WorkingSetMenuContributionItem
extends ContributionItem {
    private WorkingSetFilterActionGroup actionGroup;

    public WorkingSetMenuContributionItem(String id, WorkingSetFilterActionGroup actionGroup) {
        super(String.valueOf(id) + "org.eclipse.team.ui" + "working_set_contribution");
        Assert.isNotNull((Object)((Object)actionGroup));
        this.actionGroup = actionGroup;
    }

    public void fill(Menu menu, int index) {
        IWorkingSet[] workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getRecentWorkingSets();
        List<IWorkingSet> sortedWorkingSets = Arrays.asList(workingSets);
        Collections.sort(sortedWorkingSets, new WorkingSetComparator());
        Iterator<IWorkingSet> iter = sortedWorkingSets.iterator();
        sortedWorkingSets.size();
        int i = 0;
        while (iter.hasNext()) {
            final IWorkingSet workingSet = iter.next();
            if (workingSet == null) continue;
            MenuItem mi = new MenuItem(menu, 16, index + i);
            mi.setText("&" + ++i + " " + workingSet.getName());
            mi.setSelection(workingSet.equals(this.actionGroup.getWorkingSet()));
            mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
                    WorkingSetMenuContributionItem.this.actionGroup.setWorkingSet(workingSet);
                    manager.addRecentWorkingSet(workingSet);
                }
            });
        }
    }

    public boolean isDynamic() {
        return true;
    }
}

