/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.synchronize.actions.ClearWorkingSetAction;
import org.eclipse.team.internal.ui.synchronize.actions.EditWorkingSetAction;
import org.eclipse.team.internal.ui.synchronize.actions.SelectWorkingSetAction;
import org.eclipse.team.internal.ui.synchronize.actions.WorkingSetMenuContributionItem;
import org.eclipse.team.ui.synchronize.ISynchronizeView;
import org.eclipse.team.ui.synchronize.TeamSubscriberParticipant;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;

public class WorkingSetFilterActionGroup
extends ActionGroup {
    public static final String CHANGE_WORKING_SET = "changeWorkingSet";
    private IWorkingSet workingSet = null;
    private ClearWorkingSetAction clearWorkingSetAction;
    private SelectWorkingSetAction selectWorkingSetAction;
    private EditWorkingSetAction editWorkingSetAction;
    private IPropertyChangeListener workingSetUpdater;
    private IActionBars bars;
    private IContributionItem item;
    private String id;

    public WorkingSetFilterActionGroup(Shell shell, IPropertyChangeListener workingSetUpdater, ISynchronizeView view, TeamSubscriberParticipant participant) {
        Assert.isNotNull((Object)shell);
        this.id = participant.toString();
        this.workingSetUpdater = workingSetUpdater;
        this.workingSet = participant.getWorkingSet();
        this.clearWorkingSetAction = new ClearWorkingSetAction(this);
        this.selectWorkingSetAction = new SelectWorkingSetAction(this, shell);
        this.editWorkingSetAction = new EditWorkingSetAction(this, shell);
    }

    public void fillActionBars(IActionBars actionBars) {
        this.bars = actionBars;
        IMenuManager menuManager = actionBars.getMenuManager();
        menuManager.add((IAction)this.selectWorkingSetAction);
        menuManager.add((IAction)this.clearWorkingSetAction);
        menuManager.add((IAction)this.editWorkingSetAction);
        menuManager.add((IContributionItem)new Separator(this.id));
        this.updateMruContribution(menuManager);
    }

    private void updateMruContribution(IMenuManager menuManager) {
        IWorkingSet[] sets = PlatformUI.getWorkbench().getWorkingSetManager().getRecentWorkingSets();
        if (sets.length > 0) {
            if (this.item == null) {
                this.item = new WorkingSetMenuContributionItem(this.id, this);
                menuManager.prependToGroup(this.id, this.item);
            }
        } else {
            if (this.item != null) {
                menuManager.remove(this.item);
            }
            this.item = null;
        }
    }

    public IWorkingSet getWorkingSet() {
        return this.workingSet;
    }

    public void setWorkingSet(IWorkingSet newWorkingSet) {
        IWorkingSet oldWorkingSet = this.workingSet;
        this.workingSet = newWorkingSet;
        this.clearWorkingSetAction.setEnabled(newWorkingSet != null);
        this.editWorkingSetAction.setEnabled(newWorkingSet != null);
        if (this.workingSet != null) {
            PlatformUI.getWorkbench().getWorkingSetManager().addRecentWorkingSet(newWorkingSet);
        }
        if (this.workingSetUpdater != null) {
            this.workingSetUpdater.propertyChange(new PropertyChangeEvent((Object)this, CHANGE_WORKING_SET, (Object)oldWorkingSet, (Object)newWorkingSet));
        }
        if (this.bars.getMenuManager().find(this.id) != null) {
            this.updateMruContribution(this.bars.getMenuManager());
        }
    }
}

