/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.actions.ShowSynchronizeParticipantAction;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantListener;
import org.eclipse.team.ui.synchronize.ISynchronizeView;
import org.eclipse.ui.texteditor.IUpdate;

public class SynchronizePageDropDownAction
extends Action
implements IMenuCreator,
ISynchronizeParticipantListener,
IUpdate {
    private ISynchronizeView fView;
    private Menu fMenu;

    public void update() {
        ISynchronizeParticipant[] pages = TeamUI.getSynchronizeManager().getSynchronizeParticipants();
        this.setEnabled(pages.length >= 1);
    }

    public SynchronizePageDropDownAction(ISynchronizeView view) {
        this.fView = view;
        Utils.initAction((IAction)this, "action.refreshSubscriber.");
        this.setMenuCreator(this);
        TeamUI.getSynchronizeManager().addSynchronizeParticipantListener(this);
        this.update();
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fView = null;
        TeamUI.getSynchronizeManager().removeSynchronizeParticipantListener(this);
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        ISynchronizeParticipant[] pages = TeamUI.getSynchronizeManager().getSynchronizeParticipants();
        ISynchronizeParticipant current = this.fView.getParticipant();
        int i = 0;
        while (i < pages.length) {
            ISynchronizeParticipant page = pages[i];
            ShowSynchronizeParticipantAction action = new ShowSynchronizeParticipantAction(this.fView, page);
            action.setChecked(page.equals(current));
            this.addActionToMenu(this.fMenu, action);
            ++i;
        }
        return this.fMenu;
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    protected void addMenuSeparator() {
        new MenuItem(this.fMenu, 2);
    }

    public void run() {
    }

    public void participantsAdded(ISynchronizeParticipant[] consoles) {
        Display display = TeamUIPlugin.getStandardDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                SynchronizePageDropDownAction.this.update();
            }
        });
    }

    public void participantsRemoved(ISynchronizeParticipant[] consoles) {
        Display display = TeamUIPlugin.getStandardDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                if (SynchronizePageDropDownAction.this.fMenu != null) {
                    SynchronizePageDropDownAction.this.fMenu.dispose();
                }
                SynchronizePageDropDownAction.this.update();
            }
        });
    }
}

