/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.synchronize.actions.SelectWorkingSetAction;
import org.eclipse.team.internal.ui.synchronize.actions.StatusLineCLabelContribution;
import org.eclipse.team.internal.ui.synchronize.actions.WorkingSetFilterActionGroup;
import org.eclipse.team.internal.ui.synchronize.sets.ISyncSetChangedListener;
import org.eclipse.team.internal.ui.synchronize.sets.SubscriberInput;
import org.eclipse.team.internal.ui.synchronize.sets.SyncInfoStatistics;
import org.eclipse.team.internal.ui.synchronize.sets.SyncSetChangedEvent;
import org.eclipse.team.ui.synchronize.TeamSubscriberParticipant;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionGroup;

public class StatusLineContributionGroup
extends ActionGroup
implements ISyncSetChangedListener {
    private static final String INCOMING_ID = "org.eclipse.team.uiorg.eclipse.team.iu.statusline.incoming";
    private static final String OUTGOING_ID = "org.eclipse.team.uiorg.eclipse.team.iu.statusline.outgoing";
    private static final String CONFLICTING_ID = "org.eclipse.team.uiorg.eclipse.team.iu.statusline.conflicting";
    private static final String WORKINGSET_ID = "org.eclipse.team.uiorg.eclipse.team.iu.statusline.workingset";
    private static final int WORKING_SET_FIELD_SIZE = 25;
    private StatusLineCLabelContribution incoming;
    private StatusLineCLabelContribution outgoing;
    private StatusLineCLabelContribution conflicting;
    private StatusLineCLabelContribution workingSet;
    private Image incomingImage = TeamUIPlugin.getImageDescriptor("clcl16/incom_synch.gif").createImage();
    private Image outgoingImage = TeamUIPlugin.getImageDescriptor("clcl16/outgo_synch.gif").createImage();
    private Image conflictingImage = TeamUIPlugin.getImageDescriptor("clcl16/conflict_synch.gif").createImage();
    private SubscriberInput input;
    private TeamSubscriberParticipant participant;

    public StatusLineContributionGroup(final Shell shell, final WorkingSetFilterActionGroup setGroup, TeamSubscriberParticipant participant) {
        this.participant = participant;
        this.input = participant.getInput();
        this.incoming = this.createStatusLineContribution(INCOMING_ID, 1, "0", this.incomingImage);
        this.outgoing = this.createStatusLineContribution(OUTGOING_ID, 2, "0", this.outgoingImage);
        this.conflicting = this.createStatusLineContribution(CONFLICTING_ID, 8, "0", this.conflictingImage);
        this.workingSet = new StatusLineCLabelContribution(WORKINGSET_ID, 25);
        this.workingSet.setTooltip(Policy.bind("StatisticsPanel.workingSetTooltip"));
        this.updateWorkingSetText();
        this.workingSet.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                new SelectWorkingSetAction(setGroup, shell).run();
            }
        });
        this.input.registerListeners(this);
        participant.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("org.eclipse.team.ui.P_SYNCVIEWPAGE_WORKINGSET")) {
                    StatusLineContributionGroup.this.updateWorkingSetText();
                }
            }
        });
    }

    private void updateWorkingSetText() {
        IWorkingSet set = this.participant.getWorkingSet();
        if (set == null) {
            this.workingSet.setText(Policy.bind("StatisticsPanel.noWorkingSet"));
        } else {
            String name = set.getName();
            if (name.length() > 25) {
                name = String.valueOf(name.substring(0, 22)) + "...";
            }
            this.workingSet.setText(name);
        }
    }

    private StatusLineCLabelContribution createStatusLineContribution(String id, final int mode, String label, Image image) {
        StatusLineCLabelContribution item = new StatusLineCLabelContribution(id, 15);
        item.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                StatusLineContributionGroup.this.participant.setMode(mode);
            }
        });
        item.setText(label);
        if (image != null) {
            item.setImage(image);
            TeamUIPlugin.disposeOnShutdown(image);
        }
        return item;
    }

    public void dispose() {
        this.input.deregisterListeners(this);
        this.incomingImage.dispose();
        this.outgoingImage.dispose();
        this.conflictingImage.dispose();
    }

    public void syncSetChanged(SyncSetChangedEvent event) {
        if (this.input != null) {
            SyncInfoStatistics workspaceSetStats = this.input.getSubscriberSyncSet().getStatistics();
            SyncInfoStatistics workingSetSetStats = this.input.getWorkingSetSyncSet().getStatistics();
            final int workspaceConflicting = (int)workspaceSetStats.countFor(12, 12);
            final int workspaceOutgoing = (int)workspaceSetStats.countFor(4, 12);
            final int workspaceIncoming = (int)workspaceSetStats.countFor(8, 12);
            final int workingSetConflicting = (int)workingSetSetStats.countFor(12, 12);
            final int workingSetOutgoing = (int)workingSetSetStats.countFor(4, 12);
            final int workingSetIncoming = (int)workingSetSetStats.countFor(8, 12);
            TeamUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

                public void run() {
                    IWorkingSet set = StatusLineContributionGroup.this.input.getWorkingSet();
                    if (set != null) {
                        StatusLineContributionGroup.this.conflicting.setText(Policy.bind("StatisticsPanel.changeNumbers", new Integer(workingSetConflicting).toString(), new Integer(workspaceConflicting).toString()));
                        StatusLineContributionGroup.this.incoming.setText(Policy.bind("StatisticsPanel.changeNumbers", new Integer(workingSetIncoming).toString(), new Integer(workspaceIncoming).toString()));
                        StatusLineContributionGroup.this.outgoing.setText(Policy.bind("StatisticsPanel.changeNumbers", new Integer(workingSetOutgoing).toString(), new Integer(workspaceOutgoing).toString()));
                        StatusLineContributionGroup.this.conflicting.setTooltip(Policy.bind("StatisticsPanel.numbersWorkingSetTooltip", Policy.bind("StatisticsPanel.conflicting"), set.getName()));
                        StatusLineContributionGroup.this.outgoing.setTooltip(Policy.bind("StatisticsPanel.numbersWorkingSetTooltip", Policy.bind("StatisticsPanel.outgoing"), set.getName()));
                        StatusLineContributionGroup.this.incoming.setTooltip(Policy.bind("StatisticsPanel.numbersWorkingSetTooltip", Policy.bind("StatisticsPanel.incoming"), set.getName()));
                    } else {
                        StatusLineContributionGroup.this.conflicting.setText(new Integer(workspaceConflicting).toString());
                        StatusLineContributionGroup.this.incoming.setText(new Integer(workspaceIncoming).toString());
                        StatusLineContributionGroup.this.outgoing.setText(new Integer(workspaceOutgoing).toString());
                        StatusLineContributionGroup.this.conflicting.setTooltip(Policy.bind("StatisticsPanel.numbersTooltip", Policy.bind("StatisticsPanel.conflicting")));
                        StatusLineContributionGroup.this.outgoing.setTooltip(Policy.bind("StatisticsPanel.numbersTooltip", Policy.bind("StatisticsPanel.outgoing")));
                        StatusLineContributionGroup.this.incoming.setTooltip(Policy.bind("StatisticsPanel.numbersTooltip", Policy.bind("StatisticsPanel.incoming")));
                    }
                }
            });
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        IStatusLineManager mgr = actionBars.getStatusLineManager();
        mgr.add((IContributionItem)this.workingSet);
        mgr.add((IContributionItem)this.incoming);
        mgr.add((IContributionItem)this.outgoing);
        mgr.add((IContributionItem)this.conflicting);
    }
}

