/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.synchronize.actions.WorkingSetFilterActionGroup;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;

public class SelectWorkingSetAction
extends Action {
    private Shell shell;
    private WorkingSetFilterActionGroup actionGroup;

    public SelectWorkingSetAction(WorkingSetFilterActionGroup actionGroup, Shell shell) {
        super(WorkbenchMessages.getString((String)"SelectWorkingSetAction.text"));
        Assert.isNotNull((Object)((Object)actionGroup));
        this.setToolTipText(WorkbenchMessages.getString((String)"SelectWorkingSetAction.toolTip"));
        this.shell = shell;
        this.actionGroup = actionGroup;
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.select_working_set_action_context");
    }

    public void run() {
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetSelectionDialog dialog = manager.createWorkingSetSelectionDialog(this.shell, false);
        IWorkingSet workingSet = this.actionGroup.getWorkingSet();
        if (workingSet != null) {
            dialog.setSelection(new IWorkingSet[]{workingSet});
        }
        if (dialog.open() == 0) {
            IWorkingSet[] result = dialog.getSelection();
            if (result != null && result.length > 0) {
                this.actionGroup.setWorkingSet(result[0]);
                manager.addRecentWorkingSet(result[0]);
            } else {
                this.actionGroup.setWorkingSet(null);
            }
        } else {
            this.actionGroup.setWorkingSet(workingSet);
        }
    }
}

