/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.TeamSubscriber;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.jobs.JobStatusHandler;
import org.eclipse.team.internal.ui.jobs.RefreshSubscriberJob;
import org.eclipse.team.internal.ui.synchronize.sets.SubscriberInput;
import org.eclipse.team.internal.ui.synchronize.views.SyncSetContentProvider;
import org.eclipse.team.ui.synchronize.TeamSubscriberParticipant;
import org.eclipse.team.ui.synchronize.actions.SubscriberAction;
import org.eclipse.ui.IWorkbenchPage;

public class RefreshAction
extends Action {
    private boolean refreshAll;
    private IWorkbenchPage page;
    private TeamSubscriberParticipant participant;

    public RefreshAction(IWorkbenchPage page, TeamSubscriberParticipant participant, boolean refreshAll) {
        this.participant = participant;
        this.page = page;
        this.refreshAll = refreshAll;
        Utils.initAction((IAction)this, "action.refreshWithRemote.");
    }

    public void run() {
        ISelection selection = this.page.getSelection();
        if (selection instanceof IStructuredSelection) {
            IResource[] resources = this.getResources((IStructuredSelection)selection);
            SubscriberInput input = this.participant.getInput();
            if (this.refreshAll || resources.length == 0) {
                resources = input.workingSetRoots();
            }
            RefreshAction.run(resources, this.participant);
        }
    }

    private IResource[] getResources(IStructuredSelection selection) {
        if (selection == null) {
            return new IResource[0];
        }
        ArrayList<IResource> resources = new ArrayList<IResource>();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            IResource resource = SyncSetContentProvider.getResource(it.next());
            if (resource == null) continue;
            resources.add(resource);
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    public static void run(IResource[] resources, TeamSubscriberParticipant participant) {
        Platform.getJobManager().cancel(RefreshSubscriberJob.getFamily());
        if (TeamUIPlugin.getPlugin().getPreferenceStore().getBoolean("org.eclipse.team.ui.background_sync")) {
            RefreshSubscriberJob job = new RefreshSubscriberJob(Policy.bind("SyncViewRefresh.taskName", participant.getName()), resources, participant.getInput().getSubscriber());
            JobStatusHandler.schedule((Job)job, SubscriberAction.SUBSCRIBER_JOB_TYPE);
        } else {
            RefreshAction.runBlocking(participant.getInput().getSubscriber(), resources);
        }
    }

    private static void runBlocking(final TeamSubscriber s, final IResource[] resources) {
        TeamUIPlugin.run(new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask(null, 100);
                        s.refresh(resources, 2, Policy.subMonitorFor(monitor, 100));
                    }
                    catch (TeamException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        });
    }
}

