/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.synchronize.views.SyncSetContentProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.ui.actions.MoveResourceAction;
import org.eclipse.ui.actions.RenameResourceAction;
import org.eclipse.ui.actions.TextActionHandler;

public class RefactorActionGroup
extends ActionGroup {
    private DeleteResourceAction deleteAction;
    private MoveResourceAction moveAction;
    private RenameResourceAction renameAction;
    private TextActionHandler textActionHandler;
    private IWorkbenchPart part;
    static /* synthetic */ Class class$0;

    public RefactorActionGroup(IWorkbenchPart part) {
        this.part = part;
        this.makeActions();
    }

    public void fillContextMenu(IMenuManager parentMenu) {
        IStructuredSelection selection = this.getSelection();
        boolean anyResourceSelected = !selection.isEmpty() && this.allResourcesAreOfType(selection, 7);
        MenuManager menu = new MenuManager(Policy.bind("RefactorActionGroup.0"));
        IStructuredSelection convertedSelection = this.convertSelection(selection);
        if (anyResourceSelected) {
            this.deleteAction.selectionChanged(convertedSelection);
            menu.add((IAction)this.deleteAction);
            this.moveAction.selectionChanged(convertedSelection);
            menu.add((IAction)this.moveAction);
            this.renameAction.selectionChanged(convertedSelection);
            menu.add((IAction)this.renameAction);
        }
        parentMenu.add((IContributionItem)menu);
    }

    private IStructuredSelection convertSelection(IStructuredSelection selection) {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            IResource resource = SyncSetContentProvider.getResource(it.next());
            if (resource == null) continue;
            resources.add(resource);
        }
        return new StructuredSelection(resources);
    }

    public void fillActionBars(IActionBars actionBars) {
        this.textActionHandler = new TextActionHandler(actionBars);
        this.textActionHandler.setDeleteAction((IAction)this.deleteAction);
        this.renameAction.setTextActionHandler(this.textActionHandler);
    }

    protected void makeActions() {
        IWorkbenchPartSite site = this.part.getSite();
        IKeyBindingService keyBindingService = site.getKeyBindingService();
        Shell shell = site.getShell();
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.moveAction = new MoveResourceAction(shell);
        this.renameAction = new RenameResourceAction(shell);
        this.deleteAction = new DeleteResourceAction(shell);
        this.deleteAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.deleteAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE"));
        this.deleteAction.setHoverImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE_HOVER"));
        this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        keyBindingService.registerAction((IAction)this.deleteAction);
    }

    public void updateActionBars() {
        IStructuredSelection selection = this.getSelection();
        this.deleteAction.selectionChanged(selection);
        this.moveAction.selectionChanged(selection);
        this.renameAction.selectionChanged(selection);
    }

    private IStructuredSelection getSelection() {
        return (IStructuredSelection)this.part.getSite().getPage().getSelection();
    }

    private boolean allResourcesAreOfType(IStructuredSelection selection, int resourceMask) {
        Iterator resources = selection.iterator();
        while (resources.hasNext()) {
            Object next = resources.next();
            IResource resource = null;
            if (next instanceof IResource) {
                resource = (IResource)next;
            } else if (next instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)next;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("[Lorg.eclipse.core.resources.IResource;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                resource = (IResource)adaptable.getAdapter((Class)clazz);
            }
            if (resource == null) {
                resource = SyncSetContentProvider.getResource(next);
            }
            if (resource != null && (resource.getType() & resourceMask) != 0) continue;
            return false;
        }
        return true;
    }
}

