/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.internal.ui.synchronize.actions.OpenFileInSystemEditorAction;
import org.eclipse.team.internal.ui.synchronize.actions.OpenInCompareAction;
import org.eclipse.team.internal.ui.synchronize.views.SyncSetContentProvider;
import org.eclipse.team.ui.synchronize.TeamSubscriberParticipantPage;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.views.navigator.ResourceNavigatorMessages;

public class OpenWithActionGroup
extends ActionGroup {
    private OpenFileInSystemEditorAction openFileAction;
    private OpenInCompareAction openInCompareAction;
    private TeamSubscriberParticipantPage page;
    private IViewPart part;

    public OpenWithActionGroup(TeamSubscriberParticipantPage page) {
        this.page = page;
        this.part = page.getSynchronizeView();
        this.makeActions();
    }

    protected void makeActions() {
        this.openFileAction = new OpenFileInSystemEditorAction(this.part.getSite().getPage());
        this.openInCompareAction = new OpenInCompareAction(this.page);
    }

    public void fillContextMenu(IMenuManager menu) {
        this.fillOpenWithMenu(menu, (IStructuredSelection)this.part.getSite().getPage().getSelection());
    }

    private void fillOpenWithMenu(IMenuManager menu, IStructuredSelection selection) {
        if (selection == null || selection.size() != 1) {
            return;
        }
        Object element = selection.getFirstElement();
        IResource resource = this.getResource(element);
        if (!(resource instanceof IFile)) {
            return;
        }
        menu.add((IAction)this.openInCompareAction);
        if (!resource.exists()) {
            return;
        }
        this.openFileAction.selectionChanged(selection);
        menu.add((IAction)this.openFileAction);
        MenuManager submenu = new MenuManager(ResourceNavigatorMessages.getString((String)"ResourceNavigator.openWith"));
        submenu.add((IContributionItem)new OpenWithMenu(this.part.getSite().getPage(), (IAdaptable)((IFile)resource)));
        menu.add((IContributionItem)submenu);
    }

    public void runDefaultAction(IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        if (element instanceof IFile) {
            this.openFileAction.selectionChanged(selection);
            this.openFileAction.run();
        }
    }

    private IResource getResource(Object obj) {
        return SyncSetContentProvider.getResource(obj);
    }

    public void openInCompareEditor() {
        this.openInCompareAction.run();
    }
}

