/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.SyncInfo;
import org.eclipse.team.core.sync.IRemoteResource;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.actions.TeamAction;
import org.eclipse.team.internal.ui.synchronize.compare.SyncInfoCompareInput;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.TeamSubscriberParticipantPage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;

public class OpenInCompareAction
extends Action {
    private TeamSubscriberParticipantPage part;
    static /* synthetic */ Class class$0;

    public OpenInCompareAction(TeamSubscriberParticipantPage part) {
        this.part = part;
        Utils.initAction((IAction)this, "action.openInCompareEditor.");
    }

    public void run() {
        ISelection selection = this.part.getSite().getPage().getSelection();
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        SyncInfo info = OpenInCompareAction.getSyncInfo(obj);
        if (info != null) {
            OpenInCompareAction.openCompareEditor(this.part, info, true);
        }
    }

    public static SyncInfoCompareInput openCompareEditor(TeamSubscriberParticipantPage page, SyncInfo info, boolean keepFocus) {
        SyncInfoCompareInput input = OpenInCompareAction.getCompareInput(page.getParticipant(), info);
        if (input != null) {
            IWorkbenchPage wpage = page.getSite().getPage();
            IEditorPart editor = OpenInCompareAction.findReusableCompareEditor(wpage);
            if (editor != null) {
                IEditorInput otherInput = editor.getEditorInput();
                if (otherInput instanceof SyncInfoCompareInput && otherInput.equals((Object)input)) {
                    wpage.activate((IWorkbenchPart)editor);
                } else {
                    if (!OpenInCompareAction.prefetchFileContents(info)) {
                        return null;
                    }
                    if (editor != null && editor instanceof IReusableEditor) {
                        CompareUI.reuseCompareEditor((CompareEditorInput)input, (IReusableEditor)((IReusableEditor)editor));
                        wpage.activate((IWorkbenchPart)editor);
                    }
                }
            } else {
                CompareUI.openCompareEditor((CompareEditorInput)input);
            }
            if (keepFocus) {
                wpage.activate((IWorkbenchPart)page.getSynchronizeView());
            }
            return input;
        }
        return null;
    }

    private static boolean prefetchFileContents(SyncInfo info) {
        final IRemoteResource remote = info.getRemote();
        final IRemoteResource base = info.getBase();
        if (remote != null || base != null) {
            final boolean[] ok = new boolean[]{true};
            TeamUIPlugin.run(new IRunnableWithProgress(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(null, (remote == null ? 0 : 100) + (base == null ? 0 : 100));
                            if (remote != null) {
                                remote.getContents(Policy.subMonitorFor(monitor, 100));
                            }
                            if (base != null) {
                                base.getContents(Policy.subMonitorFor(monitor, 100));
                            }
                        }
                        catch (TeamException e) {
                            ok[0] = false;
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        ok[0] = !monitor.isCanceled();
                        monitor.done();
                        throw throwable;
                    }
                    {
                        Object var3_5 = null;
                    }
                    ok[0] = !monitor.isCanceled();
                    monitor.done();
                }
            });
            return ok[0];
        }
        return true;
    }

    private static SyncInfoCompareInput getCompareInput(ISynchronizeParticipant participant, SyncInfo info) {
        if (info != null && info.getLocal() instanceof IFile) {
            return SyncInfoCompareInput.createInput(participant, info);
        }
        return null;
    }

    public static IEditorPart findReusableCompareEditor(IWorkbenchPage page) {
        IEditorReference[] editorRefs = page.getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            IEditorPart part = editorRefs[i].getEditor(true);
            if (part != null && part.getEditorInput() instanceof SyncInfoCompareInput && !part.isDirty()) {
                return part;
            }
            ++i;
        }
        return null;
    }

    public static void closeCompareEditorFor(final IWorkbenchPartSite site, final IResource resource) {
        site.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IEditorPart editor = OpenInCompareAction.findOpenCompareEditor(site, resource);
                if (editor != null) {
                    site.getPage().closeEditor(editor, true);
                }
            }
        });
    }

    public static IEditorPart findOpenCompareEditor(IWorkbenchPartSite site, IResource resource) {
        IWorkbenchPage page = site.getPage();
        IEditorReference[] editorRefs = page.getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            IEditorPart part = editorRefs[i].getEditor(false);
            if (part != null) {
                SyncInfo inputInfo;
                IEditorInput input = part.getEditorInput();
                if (part != null && input instanceof SyncInfoCompareInput && (inputInfo = ((SyncInfoCompareInput)input).getSyncInfo()).getLocal().equals((Object)resource)) {
                    return part;
                }
            }
            ++i;
        }
        return null;
    }

    public static SyncInfo getSyncInfo(Object obj) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.team.core.subscribers.SyncInfo;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (SyncInfo)TeamAction.getAdapter(obj, clazz);
    }
}

