/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ICompareNavigator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.core.subscribers.SyncInfo;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.actions.INavigableControl;
import org.eclipse.team.internal.ui.synchronize.actions.OpenInCompareAction;
import org.eclipse.team.ui.synchronize.TeamSubscriberParticipantPage;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionFactory;

public class NavigateAction
extends Action {
    private final int direction;
    private TeamSubscriberParticipantPage page;
    static /* synthetic */ Class class$0;

    public NavigateAction(IViewPart part, TeamSubscriberParticipantPage page, int direction) {
        this.page = page;
        this.direction = direction;
        part.getSite().getKeyBindingService();
        if (direction == 1) {
            Utils.initAction((IAction)this, "action.navigateNext.");
            page.getSite().getActionBars().setGlobalActionHandler(ActionFactory.NEXT.getId(), (IAction)this);
        } else {
            Utils.initAction((IAction)this, "action.navigatePrevious.");
            page.getSite().getActionBars().setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), (IAction)this);
        }
    }

    public void run() {
        this.navigate();
    }

    private void navigate() {
        SyncInfo info = this.getSyncInfoFromSelection();
        INavigableControl navigable = (INavigableControl)this.page.getViewer();
        if (info == null) {
            if (navigable.gotoDifference(this.direction)) {
                return;
            }
            info = this.getSyncInfoFromSelection();
            if (info == null) {
                return;
            }
        }
        if (info.getLocal().getType() != 1) {
            if (!navigable.gotoDifference(this.direction)) {
                info = this.getSyncInfoFromSelection();
                OpenInCompareAction.openCompareEditor(this.page, info, true);
            }
            return;
        }
        IEditorPart editor = OpenInCompareAction.findOpenCompareEditor(this.page.getSynchronizeView().getSite(), info.getLocal());
        if (editor != null) {
            ICompareNavigator navigator;
            CompareEditorInput input = (CompareEditorInput)editor.getEditorInput();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.compare.ICompareNavigator;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((navigator = (ICompareNavigator)input.getAdapter((Class)clazz)) != null && navigator.selectChange(this.direction == 1) && !navigable.gotoDifference(this.direction)) {
                info = this.getSyncInfoFromSelection();
                OpenInCompareAction.openCompareEditor(this.page, info, true);
            }
        } else {
            OpenInCompareAction.openCompareEditor(this.page, info, true);
        }
    }

    private SyncInfo getSyncInfoFromSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.page.getSynchronizeView().getSite().getPage().getSelection();
        if (selection == null) {
            return null;
        }
        Object obj = selection.getFirstElement();
        SyncInfo info = OpenInCompareAction.getSyncInfo(obj);
        return info;
    }
}

