/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.synchronize.actions.WorkingSetFilterActionGroup;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetEditWizard;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;

public class EditWorkingSetAction
extends Action {
    private Shell shell;
    private WorkingSetFilterActionGroup actionGroup;

    public EditWorkingSetAction(WorkingSetFilterActionGroup actionGroup, Shell shell) {
        super(WorkbenchMessages.getString((String)"EditWorkingSetAction.text"));
        Assert.isNotNull((Object)((Object)actionGroup));
        this.setToolTipText(WorkbenchMessages.getString((String)"EditWorkingSetAction.toolTip"));
        this.shell = shell;
        this.actionGroup = actionGroup;
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.edit_working_set_action_context");
    }

    public void run() {
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet workingSet = this.actionGroup.getWorkingSet();
        if (workingSet == null) {
            this.setEnabled(false);
            return;
        }
        IWorkingSetEditWizard wizard = manager.createWorkingSetEditWizard(workingSet);
        if (wizard == null) {
            String title = WorkbenchMessages.getString((String)"EditWorkingSetAction.error.nowizard.title");
            String message = WorkbenchMessages.getString((String)"EditWorkingSetAction.error.nowizard.message");
            MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
            return;
        }
        WizardDialog dialog = new WizardDialog(this.shell, (IWizard)wizard);
        dialog.create();
        if (dialog.open() == 0) {
            this.actionGroup.setWorkingSet(wizard.getSelection());
        }
    }
}

