/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.ComparisonCriteria;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.sets.SubscriberInput;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;

public class ComparisonCriteriaActionGroup
extends Action
implements IMenuCreator {
    private ComparisonCriteria[] criteria;
    private ComparisonCriteriaAction[] actions;
    private SubscriberInput input;
    private Menu fMenu;

    public ComparisonCriteriaActionGroup(SubscriberInput input) {
        this.input = input;
        this.setMenuCreator(this);
        Utils.initAction((IAction)this, "action.comparisonCriteria.");
        this.initializeActions();
    }

    public void activate(final ComparisonCriteriaAction activatedAction) {
        int i = 0;
        while (i < this.actions.length) {
            ComparisonCriteriaAction action;
            action.setChecked(activatedAction == (action = this.actions[i]));
            ++i;
        }
        TeamUIPlugin.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    ComparisonCriteriaActionGroup.this.input.getSubscriber().setCurrentComparisonCriteria(activatedAction.getComparisonCriteria().getId());
                    ComparisonCriteriaActionGroup.this.input.reset();
                }
                catch (TeamException e) {
                    throw new InvocationTargetException(e);
                }
            }
        });
    }

    public void initializeActions() {
        this.criteria = this.input.getSubscriber().getComparisonCriterias();
        this.actions = new ComparisonCriteriaAction[this.criteria.length];
        int i = 0;
        while (i < this.criteria.length) {
            ComparisonCriteria c = this.criteria[i];
            this.actions[i] = new ComparisonCriteriaAction(c);
            this.actions[i].setChecked(c == this.input.getSubscriber().getCurrentComparisonCriteria());
            ++i;
        }
    }

    public void update() {
        ISynchronizeParticipant[] pages = TeamUI.getSynchronizeManager().getSynchronizeParticipants();
        this.setEnabled(pages.length >= 1);
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        ComparisonCriteria currentComparisonCriteria = this.input.getSubscriber().getCurrentComparisonCriteria();
        int i = 0;
        while (i < this.actions.length) {
            ComparisonCriteriaAction action;
            action.setChecked((action = this.actions[i]).getComparisonCriteria() == currentComparisonCriteria);
            this.addActionToMenu(this.fMenu, action);
            ++i;
        }
        return this.fMenu;
    }

    public void run() {
    }

    public void addActionsToMenuMgr(IMenuManager menu) {
        ComparisonCriteria currentComparisonCriteria = this.input.getSubscriber().getCurrentComparisonCriteria();
        int i = 0;
        while (i < this.actions.length) {
            ComparisonCriteriaAction action;
            action.setChecked((action = this.actions[i]).getComparisonCriteria() == currentComparisonCriteria);
            menu.add((IAction)action);
            ++i;
        }
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    protected void addMenuSeparator() {
        new MenuItem(this.fMenu, 2);
    }

    class ComparisonCriteriaAction
    extends Action {
        private ComparisonCriteria criteria;

        public ComparisonCriteriaAction(ComparisonCriteria criteria) {
            super(criteria.getName(), 8);
            this.criteria = criteria;
        }

        public void run() {
            ComparisonCriteriaActionGroup.this.activate(this);
        }

        public ComparisonCriteria getComparisonCriteria() {
            return this.criteria;
        }
    }
}

