/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.synchronize.SynchronizeViewWorkbenchPart;
import org.eclipse.team.internal.ui.synchronize.actions.SynchronizePageDropDownAction;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeManager;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantListener;
import org.eclipse.team.ui.synchronize.ISynchronizeView;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

public class SynchronizeView
extends PageBookView
implements ISynchronizeView,
ISynchronizeParticipantListener,
IPropertyChangeListener {
    private ISynchronizeParticipant activeParticipant = null;
    private Map fPageToPart = new HashMap();
    private Map fPartToPage = new HashMap();
    private SynchronizePageDropDownAction fPageDropDown;

    public void propertyChange(PropertyChangeEvent event) {
        Object source = event.getSource();
        if (source instanceof ISynchronizeParticipant && event.getProperty().equals("org.eclipse.jface.text") && source.equals(this.getParticipant())) {
            this.updateTitle();
        }
    }

    public void partClosed(IWorkbenchPart part) {
        super.partClosed(part);
    }

    public ISynchronizeParticipant getParticipant() {
        return this.activeParticipant;
    }

    protected void showPageRec(PageBookView.PageRec pageRec) {
        super.showPageRec(pageRec);
        this.activeParticipant = (ISynchronizeParticipant)this.fPartToPage.get(pageRec.part);
        this.updateTitle();
    }

    protected void updateTitle() {
        ISynchronizeParticipant page = this.getParticipant();
        if (page == null) {
            this.setTitle(Policy.bind("SynchronizeView.1"));
        } else {
            this.setTitle(String.valueOf(Policy.bind("SynchronizeView.2")) + page.getName());
        }
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        IPage page = pageRecord.page;
        page.dispose();
        pageRecord.dispose();
        ISynchronizeParticipant participant = (ISynchronizeParticipant)this.fPartToPage.get(part);
        participant.removePropertyChangeListener(this);
        this.fPartToPage.remove(part);
        this.fPageToPart.remove(participant);
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart dummyPart) {
        SynchronizeViewWorkbenchPart part = (SynchronizeViewWorkbenchPart)dummyPart;
        ISynchronizeParticipant participant = part.getConsole();
        IPageBookViewPage page = participant.createPage(this);
        this.initPage(page);
        page.createControl((Composite)this.getPageBook());
        participant.addPropertyChangeListener(this);
        PageBookView.PageRec rec = new PageBookView.PageRec(dummyPart, (IPage)page);
        return rec;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof SynchronizeViewWorkbenchPart;
    }

    public void dispose() {
        super.dispose();
        TeamUI.getSynchronizeManager().removeSynchronizeParticipantListener(this);
    }

    protected IPage createDefaultPage(PageBook book) {
        MessagePage page = new MessagePage();
        page.createControl((Composite)this.getPageBook());
        this.initPage((IPageBookViewPage)page);
        return page;
    }

    public void participantsAdded(final ISynchronizeParticipant[] participants) {
        if (this.isAvailable()) {
            Runnable r = new Runnable(){

                public void run() {
                    int i = 0;
                    while (i < participants.length) {
                        if (SynchronizeView.this.isAvailable()) {
                            ISynchronizeParticipant participant = participants[i];
                            SynchronizeViewWorkbenchPart part = new SynchronizeViewWorkbenchPart(participant, SynchronizeView.this.getSite());
                            SynchronizeView.this.fPageToPart.put(participant, part);
                            SynchronizeView.this.fPartToPage.put(part, participant);
                            SynchronizeView.this.partActivated(part);
                        }
                        ++i;
                    }
                }
            };
            this.asyncExec(r);
        }
    }

    public void participantsRemoved(final ISynchronizeParticipant[] consoles) {
        if (this.isAvailable()) {
            Runnable r = new Runnable(){

                public void run() {
                    int i = 0;
                    while (i < consoles.length) {
                        if (SynchronizeView.this.isAvailable()) {
                            ISynchronizeParticipant[] available;
                            ISynchronizeParticipant console = consoles[i];
                            SynchronizeViewWorkbenchPart part = (SynchronizeViewWorkbenchPart)SynchronizeView.this.fPageToPart.get(console);
                            if (part != null) {
                                SynchronizeView.this.partClosed(part);
                            }
                            if (SynchronizeView.this.getParticipant() == null && (available = TeamUI.getSynchronizeManager().getSynchronizeParticipants()).length > 0) {
                                SynchronizeView.this.display(available[available.length - 1]);
                            }
                        }
                        ++i;
                    }
                }
            };
            this.asyncExec(r);
        }
    }

    protected void createActions() {
        this.fPageDropDown = new SynchronizePageDropDownAction(this);
    }

    protected void configureToolBar(IToolBarManager mgr) {
        mgr.add((IAction)this.fPageDropDown);
    }

    public void display(ISynchronizeParticipant participant) {
        SynchronizeViewWorkbenchPart part = (SynchronizeViewWorkbenchPart)this.fPageToPart.get(participant);
        if (part != null) {
            this.partActivated(part);
        }
    }

    protected IWorkbenchPart getBootstrapPart() {
        return null;
    }

    public void asyncExec(Runnable r) {
        if (this.isAvailable()) {
            this.getPageBook().getDisplay().asyncExec(r);
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.createActions();
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        this.configureToolBar(tbm);
        this.updateForExistingParticipants();
        this.getViewSite().getActionBars().updateActionBars();
    }

    private void updateForExistingParticipants() {
        ISynchronizeManager manager = TeamUI.getSynchronizeManager();
        ISynchronizeParticipant[] consoles = manager.getSynchronizeParticipants();
        this.participantsAdded(consoles);
        manager.addSynchronizeParticipantListener(this);
    }

    private boolean isAvailable() {
        return this.getPageBook() != null && !this.getPageBook().isDisposed();
    }
}

