/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.registry.SynchronizeParticipantDescriptor;
import org.eclipse.team.internal.ui.registry.SynchronizeParticipantRegistry;
import org.eclipse.team.ui.synchronize.ISynchronizeManager;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantDescriptor;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantListener;
import org.eclipse.team.ui.synchronize.ISynchronizeView;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class SynchronizeManager
implements ISynchronizeManager {
    private ListenerList fListeners = null;
    private Map synchronizeParticipants = new HashMap(10);
    private SynchronizeParticipantRegistry participantRegistry = new SynchronizeParticipantRegistry();
    private static final int ADDED = 1;
    private static final int REMOVED = 2;
    private static final String CTX_PARTICIPANTS = "syncparticipants";
    private static final String CTX_PARTICIPANT = "participant";
    private static final String CTX_ID = "id";
    private static final String CTX_PARTICIPANT_DATA = "data";
    private static final String FILENAME = "syncParticipants.xml";

    public void addSynchronizeParticipantListener(ISynchronizeParticipantListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList(5);
        }
        this.fListeners.add((Object)listener);
    }

    public void removeSynchronizeParticipantListener(ISynchronizeParticipantListener listener) {
        if (this.fListeners != null) {
            this.fListeners.remove((Object)listener);
        }
    }

    public ISynchronizeParticipantDescriptor getParticipantDescriptor(String id) {
        return this.participantRegistry.find(id);
    }

    public synchronized void addSynchronizeParticipants(ISynchronizeParticipant[] participants) {
        ArrayList<ISynchronizeParticipant> added = new ArrayList<ISynchronizeParticipant>(participants.length);
        int i = 0;
        while (i < participants.length) {
            block4: {
                ISynchronizeParticipant participant = participants[i];
                ParticipantInstance instance = new ParticipantInstance(this.participantRegistry.find(participant.getId()), null);
                instance.setParticipant(participant);
                this.addParticipant(instance);
                try {
                    participant.init(null);
                }
                catch (PartInitException e) {
                    TeamUIPlugin.log(4, Policy.bind("SynchronizeManager.13"), e);
                    break block4;
                }
                added.add(participant);
            }
            ++i;
        }
        if (!added.isEmpty()) {
            this.saveState();
            this.fireUpdate(added.toArray(new ISynchronizeParticipant[added.size()]), 1);
        }
    }

    public synchronized void removeSynchronizeParticipants(ISynchronizeParticipant[] participants) {
        ISynchronizeParticipant participant;
        ArrayList<ISynchronizeParticipant> removed = new ArrayList<ISynchronizeParticipant>(participants.length);
        int i = 0;
        while (i < participants.length) {
            participant = participants[i];
            if (this.removeParticipant(participant)) {
                removed.add(participant);
            }
            ++i;
        }
        if (!removed.isEmpty()) {
            this.saveState();
            this.fireUpdate(removed.toArray(new ISynchronizeParticipant[removed.size()]), 2);
            Iterator it = removed.iterator();
            while (it.hasNext()) {
                participant = (ISynchronizeParticipant)it.next();
                participant.dispose();
            }
        }
    }

    public synchronized ISynchronizeParticipant[] getSynchronizeParticipants() {
        ArrayList<ISynchronizeParticipant> participants = new ArrayList<ISynchronizeParticipant>();
        Iterator it = this.synchronizeParticipants.keySet().iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            ISynchronizeParticipant[] instances = this.find(id);
            participants.addAll(Arrays.asList(instances));
        }
        return participants.toArray(new ISynchronizeParticipant[participants.size()]);
    }

    public ISynchronizeParticipant[] find(String id) {
        List instances = (List)this.synchronizeParticipants.get(id);
        if (instances == null) {
            return new ISynchronizeParticipant[0];
        }
        ArrayList<ISynchronizeParticipant> participants = new ArrayList<ISynchronizeParticipant>(instances.size());
        Iterator it = instances.iterator();
        while (it.hasNext()) {
            ParticipantInstance instance = (ParticipantInstance)it.next();
            try {
                ISynchronizeParticipant participant = instance.getParticipant();
                if (participant == null) continue;
                participants.add(participant);
            }
            catch (TeamException e) {
                this.synchronizeParticipants.remove(instance);
                TeamUIPlugin.log((CoreException)((Object)e));
            }
        }
        return participants.toArray(new ISynchronizeParticipant[participants.size()]);
    }

    public ISynchronizeView showSynchronizeViewInActivePage(IWorkbenchPage activePage) {
        IWorkbench workbench = TeamUIPlugin.getPlugin().getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (!TeamUIPlugin.getPlugin().getPreferenceStore().getString("org.eclipse.team.ui.syncview_default_perspective").equals("org.eclipse.team.ui.sync_view_perspective_none")) {
            try {
                String pId = TeamUIPlugin.getPlugin().getPreferenceStore().getString("org.eclipse.team.ui.syncview_default_perspective");
                activePage = workbench.showPerspective(pId, window);
            }
            catch (WorkbenchException e) {
                Utils.handleError(window.getShell(), (Exception)((Object)e), Policy.bind("SynchronizeView.14"), e.getMessage());
            }
        }
        try {
            if (activePage == null && (activePage = TeamUIPlugin.getActivePage()) == null) {
                return null;
            }
            return (ISynchronizeView)activePage.showView("org.eclipse.team.sync.views.SynchronizeView");
        }
        catch (PartInitException pe) {
            Utils.handleError(window.getShell(), (Exception)((Object)pe), Policy.bind("SynchronizeView.16"), pe.getMessage());
            return null;
        }
    }

    public void init() {
        try {
            this.participantRegistry.readRegistry(Platform.getPluginRegistry(), "org.eclipse.team.ui", "synchronizeParticipants");
            this.restoreSavedParticipants();
            this.initializeStaticParticipants();
        }
        catch (CoreException e) {
            TeamUIPlugin.log((IStatus)new Status(4, "org.eclipse.team.ui", 1, Policy.bind("SynchronizeManager.8"), (Throwable)e));
        }
    }

    public void dispose() {
        Iterator it = this.synchronizeParticipants.keySet().iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            List participants = (List)this.synchronizeParticipants.get(id);
            Iterator it2 = participants.iterator();
            while (it2.hasNext()) {
                ParticipantInstance instance = (ParticipantInstance)it2.next();
                instance.dispose();
            }
        }
        this.saveState();
    }

    private void initializeStaticParticipants() throws CoreException {
        SynchronizeParticipantDescriptor[] desc = this.participantRegistry.getSynchronizeParticipants();
        new ArrayList();
        int i = 0;
        while (i < desc.length) {
            SynchronizeParticipantDescriptor descriptor = desc[i];
            if (descriptor.isStatic() && !this.synchronizeParticipants.containsKey(descriptor.getId())) {
                this.addParticipant(new ParticipantInstance(descriptor, null));
            }
            ++i;
        }
    }

    private void restoreSavedParticipants() throws TeamException, CoreException {
        BufferedReader reader;
        File file = this.getStateFile();
        try {
            reader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        new ArrayList();
        XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
        IMemento[] participantNodes = memento.getChildren(CTX_PARTICIPANT);
        int i = 0;
        while (i < participantNodes.length) {
            IMemento memento2 = participantNodes[i];
            String id = memento2.getString(CTX_ID);
            SynchronizeParticipantDescriptor desc = this.participantRegistry.find(id);
            if (desc != null) {
                desc.getConfigurationElement();
                this.addParticipant(new ParticipantInstance(desc, memento2.getChild(CTX_PARTICIPANT_DATA)));
            } else {
                TeamUIPlugin.log((IStatus)new Status(4, "org.eclipse.team.ui", 1, Policy.bind("SynchronizeManager.9", id), null));
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveState() {
        XMLMemento xmlMemento = XMLMemento.createWriteRoot((String)CTX_PARTICIPANTS);
        new ArrayList();
        Iterator it = this.synchronizeParticipants.keySet().iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            List participants = (List)this.synchronizeParticipants.get(id);
            Iterator it2 = participants.iterator();
            while (it2.hasNext()) {
                ParticipantInstance instance = (ParticipantInstance)it2.next();
                IMemento participantNode = xmlMemento.createChild(CTX_PARTICIPANT);
                participantNode.putString(CTX_ID, instance.getId());
                IMemento participantData = participantNode.createChild(CTX_PARTICIPANT_DATA);
                if (instance.isParticipantInitialized()) {
                    ISynchronizeParticipant participant;
                    try {
                        participant = instance.getParticipant();
                    }
                    catch (TeamException teamException) {
                        continue;
                    }
                    participant.saveState(participantData);
                    continue;
                }
                IMemento savedState = instance.getSavedState();
                if (savedState == null) continue;
                participantData.putMemento(savedState);
            }
        }
        try {
            Object var3_4;
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.getStateFile()));
            try {
                xmlMemento.save((Writer)writer);
                var3_4 = null;
            }
            catch (Throwable throwable) {
                var3_4 = null;
                ((Writer)writer).close();
                throw throwable;
            }
            ((Writer)writer).close();
            return;
        }
        catch (IOException e) {
            TeamUIPlugin.log((IStatus)new Status(4, "org.eclipse.team.ui", 1, Policy.bind("SynchronizeManager.10"), (Throwable)e));
        }
    }

    private File getStateFile() {
        IPath pluginStateLocation = TeamUIPlugin.getPlugin().getStateLocation();
        return pluginStateLocation.append(FILENAME).toFile();
    }

    private synchronized void addParticipant(ParticipantInstance instance) {
        String id = instance.getId();
        ArrayList<ParticipantInstance> instances = (ArrayList<ParticipantInstance>)this.synchronizeParticipants.get(id);
        if (instances == null) {
            instances = new ArrayList<ParticipantInstance>(2);
            this.synchronizeParticipants.put(id, instances);
        }
        instances.add(instance);
    }

    private synchronized boolean removeParticipant(ISynchronizeParticipant participant) {
        boolean removed = false;
        String id = participant.getId();
        List instances = (List)this.synchronizeParticipants.get(id);
        if (instances != null) {
            Iterator it = instances.iterator();
            ParticipantInstance instance = null;
            while (it.hasNext()) {
                ParticipantInstance tempInstance = (ParticipantInstance)it.next();
                try {
                    if (tempInstance.getParticipant() != participant) continue;
                    instance = tempInstance;
                }
                catch (TeamException e) {
                    this.synchronizeParticipants.remove(tempInstance);
                    TeamUIPlugin.log((CoreException)((Object)e));
                }
            }
            if (instance != null) {
                removed = instances.remove(instance);
                if (instances.isEmpty()) {
                    this.synchronizeParticipants.remove(id);
                }
            }
        }
        return removed;
    }

    private void fireUpdate(ISynchronizeParticipant[] participants, int type) {
        new SynchronizeViewPageNotifier().notify(participants, type);
    }

    class SynchronizeViewPageNotifier
    implements ISafeRunnable {
        private ISynchronizeParticipantListener fListener;
        private int fType;
        private ISynchronizeParticipant[] fChanged;

        SynchronizeViewPageNotifier() {
        }

        public void handleException(Throwable exception) {
            TeamUIPlugin.log(4, Policy.bind("SynchronizeManager.7"), exception);
        }

        public void run() throws Exception {
            switch (this.fType) {
                case 1: {
                    this.fListener.participantsAdded(this.fChanged);
                    break;
                }
                case 2: {
                    this.fListener.participantsRemoved(this.fChanged);
                }
            }
        }

        public void notify(ISynchronizeParticipant[] participants, int update) {
            if (SynchronizeManager.this.fListeners == null) {
                return;
            }
            this.fChanged = participants;
            this.fType = update;
            Object[] copiedListeners = SynchronizeManager.this.fListeners.getListeners();
            int i = 0;
            while (i < copiedListeners.length) {
                this.fListener = (ISynchronizeParticipantListener)copiedListeners[i];
                Platform.run((ISafeRunnable)this);
                ++i;
            }
            this.fChanged = null;
            this.fListener = null;
        }
    }

    static class ParticipantInstance {
        private ISynchronizeParticipant participant;
        private IMemento savedState;
        private SynchronizeParticipantDescriptor descriptor;

        public ParticipantInstance(SynchronizeParticipantDescriptor descriptor, IMemento savedState) {
            this.savedState = savedState;
            this.descriptor = descriptor;
        }

        public void setParticipant(ISynchronizeParticipant participant) {
            this.participant = participant;
        }

        public ISynchronizeParticipant getParticipant() throws TeamException {
            if (this.participant == null) {
                try {
                    this.participant = (ISynchronizeParticipant)TeamUIPlugin.createExtension(this.descriptor.getConfigurationElement(), "class");
                    this.participant.setInitializationData(this.descriptor.getConfigurationElement(), null, null);
                    this.participant.init(this.savedState);
                }
                catch (PartInitException e2) {
                    this.participant = null;
                    throw new TeamException(Policy.bind("SynchronizeManager.11"), (Exception)((Object)e2));
                }
                catch (CoreException e) {
                    this.participant = null;
                    throw TeamException.asTeamException((CoreException)e);
                }
            }
            return this.participant;
        }

        public boolean isParticipantInitialized() {
            return this.participant != null;
        }

        public IMemento getSavedState() {
            return this.savedState;
        }

        public boolean equals(Object other) {
            try {
                if (other == this) {
                    return true;
                }
                if (other instanceof ISynchronizeParticipant) {
                    return other == this.getParticipant();
                }
                if (other instanceof ParticipantInstance) {
                    return ((ParticipantInstance)other).getParticipant() == this.getParticipant();
                }
                return false;
            }
            catch (TeamException teamException) {
                return false;
            }
        }

        public void dispose() {
            if (this.participant != null) {
                this.participant.dispose();
            }
        }

        public String getId() {
            return this.descriptor.getId();
        }
    }
}

