/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.sync;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IPropertyChangeNotifier;
import org.eclipse.compare.NavigationAction;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.sync.SyncCompareInput;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;

public class SyncView
extends ViewPart
implements ISaveablePart,
IPropertyChangeListener {
    public static final String VIEW_ID = "org.eclipse.team.ui.sync.SyncView";
    private SyncCompareInput input;
    private Composite top;
    public static final int SYNC_NONE = 0;
    public static final int SYNC_INCOMING = 1;
    public static final int SYNC_OUTGOING = 2;
    public static final int SYNC_BOTH = 3;
    public static final int SYNC_MERGE = 4;
    public static final int SYNC_COMPARE = 5;
    private final String CATCHUP_TITLE = Policy.bind("SyncView.incomingModeTitle");
    private final String RELEASE_TITLE = Policy.bind("SyncView.outgoingModeTitle");
    private final String FREE_TITLE = Policy.bind("SyncView.freeModeTitle");
    private int currentSyncMode = 0;
    private String viewTitle = "";
    private SyncModeAction incomingMode;
    private SyncModeAction outgoingMode;
    private SyncModeAction freeMode;
    private NavigationAction next;
    private NavigationAction previous;
    private IPartListener partListener;
    static /* synthetic */ Class class$0;

    public void createPartControl(Composite parent) {
        this.top = new Composite(parent, 0);
        this.top.setData((Object)this);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.top.setLayout((Layout)layout);
        this.top.setLayoutData((Object)new GridData(1808));
        this.showDefaultContents();
        this.initializeSyncModes();
        this.partListener = new PartListener();
        this.getViewSite().getWorkbenchWindow().getPartService().addPartListener(this.partListener);
        WorkbenchHelp.setHelp((Control)this.top, (String)"org.eclipse.team.ui.sync_view_context");
    }

    public void dispose() {
        if (this.partListener != null) {
            this.getViewSite().getWorkbenchWindow().getPartService().removePartListener(this.partListener);
            this.partListener = null;
        }
        if (this.input instanceof IPropertyChangeNotifier) {
            ((IPropertyChangeNotifier)this.input).removePropertyChangeListener((IPropertyChangeListener)this);
        }
        super.dispose();
    }

    public static SyncView findViewInActivePage(IWorkbenchPage activePage) {
        try {
            if (activePage == null && (activePage = TeamUIPlugin.getActivePage()) == null) {
                return null;
            }
            IViewPart part = activePage.findView(VIEW_ID);
            if (part == null) {
                part = activePage.showView(VIEW_ID);
            }
            return (SyncView)part;
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    private void initializeSyncModes() {
        this.incomingMode = new SyncModeAction(Policy.bind("SyncView.incomingModeAction"), TeamUIPlugin.getImageDescriptor("elcl16/catchup_rls.gif"), 1);
        this.incomingMode.setToolTipText(Policy.bind("SyncView.incomingModeToolTip"));
        this.incomingMode.setChecked(false);
        this.incomingMode.setDisabledImageDescriptor(TeamUIPlugin.getImageDescriptor("dlcl16/catchup_rls.gif"));
        this.incomingMode.setHoverImageDescriptor(TeamUIPlugin.getImageDescriptor("clcl16/catchup_rls.gif"));
        this.outgoingMode = new SyncModeAction(Policy.bind("SyncView.outgoingModeAction"), TeamUIPlugin.getImageDescriptor("elcl16/release_rls.gif"), 2);
        this.outgoingMode.setToolTipText(Policy.bind("SyncView.outgoingModeToolTip"));
        this.outgoingMode.setChecked(false);
        this.outgoingMode.setDisabledImageDescriptor(TeamUIPlugin.getImageDescriptor("dlcl16/release_rls.gif"));
        this.outgoingMode.setHoverImageDescriptor(TeamUIPlugin.getImageDescriptor("clcl16/release_rls.gif"));
        this.freeMode = new SyncModeAction(Policy.bind("SyncView.freeModeAction"), TeamUIPlugin.getImageDescriptor("elcl16/catchuprelease_rls.gif"), 3);
        this.freeMode.setToolTipText(Policy.bind("SyncView.freeModeToolTip"));
        this.freeMode.setChecked(false);
        this.freeMode.setDisabledImageDescriptor(TeamUIPlugin.getImageDescriptor("dlcl16/catchuprelease_rls.gif"));
        this.freeMode.setHoverImageDescriptor(TeamUIPlugin.getImageDescriptor("clcl16/catchuprelease_rls.gif"));
        this.next = new NavigationAction(true);
        this.previous = new NavigationAction(false);
        IActionBars actionBars = this.getViewSite().getActionBars();
        if (actionBars != null) {
            actionBars.setGlobalActionHandler(ActionFactory.NEXT.getId(), (IAction)this.next);
            actionBars.setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), (IAction)this.previous);
            actionBars.updateActionBars();
        }
    }

    private boolean isEmpty(DiffNode node) {
        if (node == null) {
            return true;
        }
        if (node.getKind() != 0) {
            return false;
        }
        IDiffElement[] children = node.getChildren();
        int i = 0;
        while (i < children.length) {
            if (!this.isEmpty(children[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isEmpty(IDiffElement element) {
        if (element.getKind() != 0) {
            return false;
        }
        if (element instanceof DiffNode) {
            IDiffElement[] children = ((DiffNode)element).getChildren();
            int i = 0;
            while (i < children.length) {
                if (!this.isEmpty(children[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private boolean run(IRunnableWithProgress op) {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getSite().getShell());
        try {
            dialog.run(true, true, op);
            return true;
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getTargetException();
            Object error = null;
            error = throwable instanceof TeamException ? ((TeamException)throwable).getStatus() : (throwable instanceof CoreException ? ((CoreException)throwable).getStatus() : new Status(4, "org.eclipse.team.ui", 1, Policy.bind("simpleInternal"), throwable));
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)Policy.bind("SyncView.unableSynchronize"), null, (IStatus)error);
            TeamUIPlugin.log(error.getSeverity(), error.getMessage(), throwable);
        }
        catch (InterruptedException interruptedException) {}
        return false;
    }

    public void setFocus() {
        if (this.top != null && !this.top.isDisposed()) {
            this.top.setFocus();
        }
    }

    void setSyncMode(int mode) {
        switch (mode) {
            case 1: {
                this.incomingMode.setChecked(true);
                this.outgoingMode.setChecked(false);
                this.freeMode.setChecked(false);
                this.setTitleWithDirtyIndicator(this.CATCHUP_TITLE);
                break;
            }
            case 2: {
                this.outgoingMode.setChecked(true);
                this.incomingMode.setChecked(false);
                this.freeMode.setChecked(false);
                this.setTitleWithDirtyIndicator(this.RELEASE_TITLE);
                break;
            }
            case 3: {
                this.freeMode.setChecked(true);
                this.outgoingMode.setChecked(false);
                this.incomingMode.setChecked(false);
                this.setTitleWithDirtyIndicator(this.FREE_TITLE);
            }
        }
        if (this.input != null && this.input.getDiffRoot() != null && mode != this.currentSyncMode) {
            this.currentSyncMode = mode;
            this.input.getViewer().syncModeChanged(mode);
            this.updateActions();
        }
    }

    private void showDefaultContents() {
        Label label = new Label(this.top, 64);
        label.setLayoutData((Object)new GridData(1808));
        label.setText(Policy.bind("SyncView.text"));
    }

    public void showSync(SyncCompareInput input) {
        this.showSync(input, null);
    }

    public void showSync(SyncCompareInput input, IWorkbenchPage page) {
        Control[] oldChildren;
        this.next.setCompareEditorInput((CompareEditorInput)input);
        this.previous.setCompareEditorInput((CompareEditorInput)input);
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.updateActionBars();
        input.setViewSite(this.getViewSite());
        this.input = input;
        this.currentSyncMode = 0;
        if (input instanceof IPropertyChangeNotifier) {
            ((IPropertyChangeNotifier)input).addPropertyChangeListener((IPropertyChangeListener)this);
        }
        if ((oldChildren = this.top.getChildren()) != null) {
            int i = 0;
            while (i < oldChildren.length) {
                oldChildren[i].dispose();
                ++i;
            }
        }
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getToolBarManager().removeAll();
        bars.getToolBarManager().update(false);
        bars.getMenuManager().removeAll();
        bars.getMenuManager().update();
        bars.updateActionBars();
        this.showDefaultContents();
        this.top.layout();
        if (!this.run((IRunnableWithProgress)input)) {
            return;
        }
        if (input.getMessage() != null) {
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)Policy.bind("SyncView.unableSynchronize"), (String)input.getMessage());
            return;
        }
        if (this.isEmpty(input.getDiffRoot())) {
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)Policy.bind("nothingToSynchronize"), (String)Policy.bind("SyncView.same"));
            return;
        }
        oldChildren = this.top.getChildren();
        if (oldChildren != null) {
            int i = 0;
            while (i < oldChildren.length) {
                oldChildren[i].dispose();
                ++i;
            }
        }
        Control control = input.createContents(this.top);
        control.setLayoutData((Object)new GridData(1808));
        this.top.layout();
        if (input.hasIncomingChanges()) {
            this.incomingMode.run();
        } else {
            this.outgoingMode.run();
        }
        try {
            if (page == null) {
                page = TeamUIPlugin.getActivePage();
            }
            if (page != null) {
                page.showView(VIEW_ID);
            }
        }
        catch (PartInitException e) {
            TeamUIPlugin.log((CoreException)((Object)e));
        }
    }

    private void updateActions() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = bars.getToolBarManager();
        IMenuManager menu = bars.getMenuManager();
        toolBar.removeAll();
        menu.removeAll();
        toolBar.add((IAction)this.incomingMode);
        toolBar.add((IAction)this.outgoingMode);
        toolBar.add((IAction)this.freeMode);
        this.input.getViewer().contributeToActionBars(bars);
        toolBar.update(false);
        menu.update(false);
        bars.updateActionBars();
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.ui.part.IShowInSource;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz) {
            return new IShowInSource(){

                public ShowInContext getShowInContext() {
                    if (SyncView.this.input == null || SyncView.this.input.getViewer() == null) {
                        return null;
                    }
                    return new ShowInContext(null, SyncView.this.input.getViewer().getSelection());
                }
            };
        }
        return super.getAdapter(key);
    }

    public void doSave(IProgressMonitor monitor) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor pm) throws CoreException {
                if (SyncView.this.input instanceof CompareEditorInput) {
                    SyncView.this.input.saveChanges(pm);
                }
            }
        };
        this.getSite().getShell();
        try {
            operation.run(monitor);
            this.firePropertyChange(257);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (InvocationTargetException x) {
            String reason = x.getTargetException().getMessage();
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)Policy.bind("SyncView.cantSaveError", reason), null, null);
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        if (this.input instanceof CompareEditorInput) {
            return this.input.isSaveNeeded();
        }
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.isDirty()) {
            this.firePropertyChange(257);
        }
        this.setTitleWithDirtyIndicator(null);
    }

    private void setTitleWithDirtyIndicator(String title) {
        if (title != null) {
            this.viewTitle = title;
        }
        if (this.isDirty()) {
            this.setTitle(Policy.bind("SyncView.dirtyIndicatorInTitle", this.viewTitle));
        } else {
            this.setTitle(this.viewTitle);
        }
    }

    class SyncModeAction
    extends Action {
        private int syncMode;

        public SyncModeAction(String title, ImageDescriptor image, int mode) {
            super(title, image);
            this.syncMode = mode;
        }

        public void run() {
            SyncView.this.setSyncMode(this.syncMode);
        }
    }

    private class PartListener
    implements IPartListener {
        PartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            if (part == SyncView.this && SyncView.this.input != null) {
                SyncView.this.input.saveIfNecessary();
            }
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }
}

