/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.sync;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.compare.BufferedContent;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.NavigationAction;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.structuremergeviewer.DiffContainer;
import org.eclipse.compare.structuremergeviewer.DiffElement;
import org.eclipse.compare.structuremergeviewer.DiffTreeViewer;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.sync.CatchupReleaseViewer;
import org.eclipse.team.internal.ui.sync.ITeamNode;
import org.eclipse.team.internal.ui.sync.MergeResource;
import org.eclipse.team.internal.ui.sync.SyncCompareInput;
import org.eclipse.team.internal.ui.sync.TeamFile;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.views.navigator.ResourceNavigator;

public abstract class CatchupReleaseViewer
extends DiffTreeViewer {
    private int syncMode = 0;
    private FilterAction showIncoming;
    private FilterAction showOutgoing;
    private FilterAction showOnlyConflicts;
    private Action refresh;
    private OpenAction open;
    private ExpandAllAction expandAll;
    private RemoveFromTreeAction removeFromTree;
    private ShowInNavigatorAction showInNavigator;
    private Action ignoreWhiteSpace;
    private Action toggleGranularity;
    private NavigationAction showPrevious;
    private NavigationAction showNext;
    static final String PROP_KIND = "team.ui.PropKind";
    private Action copyAllRightToLeft;
    private boolean compareFileContents = false;

    protected CatchupReleaseViewer(Composite parent, SyncCompareInput model) {
        super(parent, model.getCompareConfiguration());
        this.setSorter(new SyncSorter());
        this.initializeActions(model);
    }

    void contributeToActionBars(IActionBars actionBars) {
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.showOnlyConflicts);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.showNext);
        toolBar.add((IAction)this.showPrevious);
        IMenuManager menu = actionBars.getMenuManager();
        if (this.syncMode == 3) {
            menu.add((IAction)this.showIncoming);
            menu.add((IAction)this.showOutgoing);
        }
        menu.add((IAction)this.toggleGranularity);
        menu.add((IAction)this.ignoreWhiteSpace);
        menu.add((IAction)this.refresh);
    }

    protected void fillContextMenu(IMenuManager manager) {
        this.open.update();
        manager.add((IAction)this.open);
        manager.add((IContributionItem)new Separator());
        this.expandAll.update();
        manager.add((IAction)this.expandAll);
        this.removeFromTree.update();
        manager.add((IAction)this.removeFromTree);
        if (this.showInNavigator != null) {
            manager.add((IAction)this.showInNavigator);
        }
        if (this.syncMode == 5 && this.copyAllRightToLeft.isEnabled()) {
            manager.add((IAction)this.copyAllRightToLeft);
        }
    }

    protected void openSelection() {
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection) {
            Iterator elements = ((IStructuredSelection)selection).iterator();
            while (elements.hasNext()) {
                Object next = elements.next();
                this.openSelection(next);
            }
        }
    }

    private void openSelection(Object next) {
        if (next instanceof TeamFile) {
            this.handleOpen(null);
        }
    }

    protected void expandSelection() {
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection) {
            Iterator elements = ((IStructuredSelection)selection).iterator();
            while (elements.hasNext()) {
                Object next = elements.next();
                this.expandToLevel(next, -1);
            }
        }
    }

    protected int getSyncMode() {
        return this.syncMode;
    }

    protected boolean hasFilteredChildren(Object element) {
        return this.getFilteredChildren(element).length > 0;
    }

    private void initializeActions(final SyncCompareInput diffModel) {
        ImageDescriptor image = TeamUIPlugin.getImageDescriptor("elcl16/incom_synch.gif");
        this.showIncoming = new FilterAction(Policy.bind("CatchupReleaseViewer.showIncomingAction"), image);
        this.showIncoming.setToolTipText(Policy.bind("CatchupReleaseViewer.showIncomingAction"));
        this.showIncoming.setDisabledImageDescriptor(TeamUIPlugin.getImageDescriptor("dlcl16/incom_synch.gif"));
        this.showIncoming.setHoverImageDescriptor(TeamUIPlugin.getImageDescriptor("clcl16/incom_synch.gif"));
        image = TeamUIPlugin.getImageDescriptor("elcl16/outgo_synch.gif");
        this.showOutgoing = new FilterAction(Policy.bind("CatchupReleaseViewer.showOutgoingAction"), image);
        this.showOutgoing.setToolTipText(Policy.bind("CatchupReleaseViewer.showOutgoingAction"));
        this.showOutgoing.setDisabledImageDescriptor(TeamUIPlugin.getImageDescriptor("dlcl16/outgo_synch.gif"));
        this.showOutgoing.setHoverImageDescriptor(TeamUIPlugin.getImageDescriptor("clcl16/outgo_synch.gif"));
        image = TeamUIPlugin.getImageDescriptor("elcl16/conflict_synch.gif");
        this.showOnlyConflicts = new FilterAction(Policy.bind("CatchupReleaseViewer.showOnlyConflictsAction"), image);
        this.showOnlyConflicts.setToolTipText(Policy.bind("CatchupReleaseViewer.showOnlyConflictsAction"));
        this.showOnlyConflicts.setDisabledImageDescriptor(TeamUIPlugin.getImageDescriptor("dlcl16/conflict_synch.gif"));
        this.showOnlyConflicts.setHoverImageDescriptor(TeamUIPlugin.getImageDescriptor("clcl16/conflict_synch.gif"));
        image = TeamUIPlugin.getImageDescriptor("elcl16/refresh.gif");
        this.refresh = new Action(Policy.bind("CatchupReleaseViewer.refreshAction"), image){

            public void run() {
                diffModel.refresh();
            }
        };
        this.refresh.setToolTipText(Policy.bind("CatchupReleaseViewer.refreshAction"));
        this.refresh.setDisabledImageDescriptor(TeamUIPlugin.getImageDescriptor("dlcl16/refresh.gif"));
        this.refresh.setHoverImageDescriptor(TeamUIPlugin.getImageDescriptor("clcl16/refresh.gif"));
        this.open = new OpenAction(Policy.bind("CatchupReleaseViewer.open"), null);
        WorkbenchHelp.setHelp((IAction)this.open, (String)"org.eclipse.team.ui.open_action_context");
        this.expandAll = new ExpandAllAction(Policy.bind("CatchupReleaseViewer.expand"), null);
        WorkbenchHelp.setHelp((IAction)this.expandAll, (String)"org.eclipse.team.ui.expandall_action_context");
        image = TeamUIPlugin.getImageDescriptor("elcl16/contents.gif");
        this.toggleGranularity = new Action(Policy.bind("CatchupReleaseViewer.Compare_File_Contents_1"), image){

            public void run() {
                CatchupReleaseViewer.this.compareFileContents = this.isChecked();
                diffModel.setSyncGranularity(CatchupReleaseViewer.this.compareFileContents ? 2 : 1);
                CatchupReleaseViewer.this.updateFilters();
            }
        };
        this.compareFileContents = diffModel.getSyncGranularity() != 1;
        this.toggleGranularity.setChecked(this.compareFileContents);
        this.toggleGranularity.setDisabledImageDescriptor(TeamUIPlugin.getImageDescriptor("dlcl16/contents.gif"));
        this.toggleGranularity.setHoverImageDescriptor(TeamUIPlugin.getImageDescriptor("clcl16/contents.gif"));
        this.removeFromTree = new RemoveFromTreeAction(Policy.bind("CatchupReleaseViewer.removeFromView"), null);
        WorkbenchHelp.setHelp((IAction)this.removeFromTree, (String)"org.eclipse.team.ui.remove_action_context");
        this.copyAllRightToLeft = new Action(Policy.bind("CatchupReleaseViewer.copyAllRightToLeft"), null){

            public void run() {
                ISelection s = CatchupReleaseViewer.this.getSelection();
                if (!(s instanceof IStructuredSelection) || s.isEmpty()) {
                    return;
                }
                Object element = ((IStructuredSelection)s).getFirstElement();
                if (element instanceof DiffElement) {
                    try {
                        new ProgressMonitorDialog(CatchupReleaseViewer.this.getTree().getShell()).run(true, true, new IRunnableWithProgress(this, element){
                            final /* synthetic */ 3 this$1;
                            private final /* synthetic */ Object val$element;
                            {
                                this.this$1 = var1_1;
                                this.val$element = object;
                            }

                            /*
                             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                try {
                                    try {
                                        monitor.beginTask(null, 1000);
                                        monitor.setTaskName(Policy.bind("CatchupReleaseViewer.Copying_right_contents_into_workspace_2"));
                                        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(this, this.val$element){
                                            final /* synthetic */ 4 this$2;
                                            private final /* synthetic */ Object val$element;
                                            {
                                                this.this$2 = var1_1;
                                                this.val$element = object;
                                            }

                                            /*
                                             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                                             * Enabled aggressive block sorting
                                             * Enabled unnecessary exception pruning
                                             * Enabled aggressive exception aggregation
                                             */
                                            public void run(IProgressMonitor monitor) throws CoreException {
                                                try {
                                                    monitor.beginTask(null, 100);
                                                    3.access$0(4.access$0(this.this$2)).copyAllRightToLeft((IDiffElement)((DiffElement)this.val$element), monitor);
                                                }
                                                catch (Throwable throwable) {
                                                    Object var2_3 = null;
                                                    monitor.done();
                                                    throw throwable;
                                                }
                                                {
                                                    Object var2_4 = null;
                                                }
                                                monitor.done();
                                            }
                                        }, Policy.subInfiniteMonitorFor(monitor, 1000));
                                    }
                                    catch (CoreException e) {
                                        throw new InvocationTargetException(e);
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var3_4 = null;
                                    monitor.done();
                                    throw throwable;
                                }
                                {
                                    Object var3_5 = null;
                                }
                                monitor.done();
                            }

                            static /* synthetic */ 3 access$0(4 var0) {
                                return var0.this$1;
                            }
                        });
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        ErrorDialog.openError((Shell)TeamUIPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Policy.bind("CatchupReleaseViewer.errorCopyAllRightToLeft"), null, null);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                CatchupReleaseViewer.this.refresh();
            }

            public boolean isEnabled() {
                ISelection s = CatchupReleaseViewer.this.getSelection();
                if (!(s instanceof IStructuredSelection) || s.isEmpty()) {
                    return false;
                }
                return ((IStructuredSelection)s).size() == 1;
            }

            static /* synthetic */ CatchupReleaseViewer access$0(3 var0) {
                return var0.CatchupReleaseViewer.this;
            }
        };
        if (diffModel.getViewSite() != null) {
            this.showInNavigator = new ShowInNavigatorAction(diffModel.getViewSite(), Policy.bind("CatchupReleaseViewer.showInNavigator"));
            WorkbenchHelp.setHelp((IAction)this.showInNavigator, (String)"org.eclipse.team.ui.navigator_show_action_context");
            this.addSelectionChangedListener(this.showInNavigator);
        }
        image = TeamUIPlugin.getImageDescriptor("elcl16/ignorews_edit.gif");
        this.ignoreWhiteSpace = new Action(Policy.bind("CatchupReleaseViewer.ignoreWhiteSpace"), image){

            public void run() {
                diffModel.setIgnoreWhitespace(this.isChecked());
            }
        };
        this.ignoreWhiteSpace.setId("team.ignoreWhiteSpace");
        boolean ignore = CompareUIPlugin.getDefault().getPreferenceStore().getBoolean("IGNORE_WHITESPACE");
        this.ignoreWhiteSpace.setChecked(ignore);
        this.ignoreWhiteSpace.setDisabledImageDescriptor(TeamUIPlugin.getImageDescriptor("dlcl16/ignorews_edit.gif"));
        this.ignoreWhiteSpace.setHoverImageDescriptor(TeamUIPlugin.getImageDescriptor("clcl16/ignorews_edit.gif"));
        this.showNext = new NavigationAction(true);
        this.showPrevious = new NavigationAction(false);
        this.showNext.setCompareEditorInput((CompareEditorInput)diffModel);
        this.showPrevious.setCompareEditorInput((CompareEditorInput)diffModel);
        this.getTree().addListener(8, new Listener(){

            public void handleEvent(Event e) {
                CatchupReleaseViewer.this.mouseDoubleClicked(e);
            }
        });
        this.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    diffModel.refresh();
                }
            }
        });
        this.showIncoming.setChecked(true);
        this.showOutgoing.setChecked(true);
        this.showOnlyConflicts.setChecked(false);
        this.setFilters(7);
    }

    private void setAllChildrenInSync(IDiffElement element) {
        if (element instanceof DiffContainer) {
            DiffContainer container = (DiffContainer)element;
            IDiffElement[] children = container.getChildren();
            int i = 0;
            while (i < children.length) {
                this.setAllChildrenInSync(children[i]);
                ++i;
            }
        }
        ((DiffElement)element).setKind(0);
    }

    protected void copyAllRightToLeft(IDiffElement element, IProgressMonitor monitor) throws CoreException {
        TeamFile file;
        Policy.checkCanceled(monitor);
        if (element instanceof DiffContainer) {
            DiffContainer container = (DiffContainer)element;
            IDiffElement[] children = container.getChildren();
            int i = 0;
            while (i < children.length) {
                this.copyAllRightToLeft(children[i], monitor);
                ++i;
            }
        } else if (element instanceof TeamFile && (file = (TeamFile)element).getKind() != 0) {
            IEditableContent editable;
            monitor.subTask(Policy.bind("CatchupReleaseViewer.MakingLocalLikeRemote", Policy.toTruncatedPath(file.getMergeResource().getResource().getFullPath(), 3)));
            file.setProgressMonitor(Policy.subNullMonitorFor(monitor));
            if (file.getRight() == null || file.getLeft() == null) {
                file.copy(false);
            }
            ITypedElement te = file.getLeft();
            ITypedElement rte = file.getRight();
            if (te instanceof IEditableContent && (editable = (IEditableContent)te).isEditable() && rte instanceof BufferedContent) {
                editable.setContent(((BufferedContent)rte).getContent());
            }
            file.setProgressMonitor(null);
            monitor.worked(1);
        }
    }

    protected void inputChanged(Object input, Object oldInput) {
        Tree tree;
        super.inputChanged(input, oldInput);
        if (this.refresh != null && (tree = this.getTree()) != null) {
            this.refresh.setEnabled(input != null);
        }
    }

    private void showSelectionInNavigator(IViewSite viewSite) {
        ISelection selection = this.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object[] selected = ((IStructuredSelection)selection).toArray();
        Object[] resources = new IResource[selected.length];
        int i = 0;
        while (i < selected.length) {
            resources[i] = ((ITeamNode)selected[i]).getResource();
            ++i;
        }
        StructuredSelection resourceSelection = new StructuredSelection(resources);
        try {
            IViewPart part = viewSite.getPage().showView("org.eclipse.ui.views.ResourceNavigator");
            if (part instanceof ResourceNavigator) {
                ((ResourceNavigator)part).selectReveal((ISelection)resourceSelection);
            }
        }
        catch (PartInitException e) {
            TeamUIPlugin.log((CoreException)((Object)e));
        }
    }

    private void mouseDoubleClicked(Event e) {
        Object first;
        IStructuredSelection structured;
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection && (structured = (IStructuredSelection)selection).size() == 1 && (first = structured.getFirstElement()) instanceof IDiffContainer) {
            this.setExpandedState(first, !this.getExpandedState(first));
        }
    }

    protected void handleOpen(SelectionEvent event) {
        IStructuredSelection structured;
        Object selected;
        ISelection selection = this.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (selected = (structured = (IStructuredSelection)selection).getFirstElement()) instanceof TeamFile) {
            this.updateLabels(((TeamFile)selected).getMergeResource());
        }
        super.handleOpen(event);
    }

    protected void updateLabels(MergeResource resource) {
        resource.setLabels(this.getCompareConfiguration());
    }

    private void setFilters(int maskToHide) {
        ViewerFilter[] filters = this.getFilters();
        if (filters != null) {
            int i = 0;
            while (i < filters.length) {
                if (filters[i] instanceof CategoryFilter) {
                    CategoryFilter filter = (CategoryFilter)filters[i];
                    filter.setMask(maskToHide);
                    this.refresh();
                    return;
                }
                ++i;
            }
        }
        this.addFilter(new CategoryFilter(maskToHide));
    }

    public void syncModeChanged(int mode) {
        this.syncMode = mode;
        this.updateFilters();
    }

    void updateFilters() {
        Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        int filters = 4;
        switch (this.syncMode) {
            case 1: 
            case 4: {
                if (this.showOnlyConflicts.isChecked()) break;
                filters |= 1;
                break;
            }
            case 2: {
                if (this.showOnlyConflicts.isChecked()) break;
                filters |= 2;
                break;
            }
            case 3: {
                boolean conflictsOnly = this.showOnlyConflicts.isChecked();
                this.showIncoming.setEnabled(!conflictsOnly);
                this.showOutgoing.setEnabled(!conflictsOnly);
                if (conflictsOnly) break;
                if (this.showIncoming.isChecked()) {
                    filters |= 1;
                }
                if (!this.showOutgoing.isChecked()) break;
                filters |= 2;
            }
        }
        if (!this.compareFileContents) {
            filters |= 8;
        }
        this.setFilters(filters);
    }

    class ShowInNavigatorAction
    extends Action
    implements ISelectionChangedListener {
        IViewSite viewSite;

        public ShowInNavigatorAction(IViewSite viewSite, String title) {
            super(title, null);
            this.viewSite = viewSite;
        }

        public void run() {
            CatchupReleaseViewer.this.showSelectionInNavigator(this.viewSite);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.size() == 0) {
                this.setEnabled(false);
                return;
            }
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                ITeamNode node = (ITeamNode)iter.next();
                if (node.getResource().isAccessible()) continue;
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
        }
    }

    class CategoryFilter
    extends ViewerFilter {
        static final int SHOW_INCOMING = 1;
        static final int SHOW_OUTGOING = 2;
        static final int SHOW_CONFLICTS = 4;
        static final int SHOW_PSEUDO_CONFLICTS = 8;
        private int showMask = 0;

        CategoryFilter(int showMask) {
            this.showMask = showMask;
        }

        int getMask() {
            return this.showMask;
        }

        void setMask(int mask) {
            this.showMask = mask;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (CatchupReleaseViewer.this.hasFilteredChildren(element)) {
                return true;
            }
            if (element instanceof ITeamNode) {
                int kind = ((ITeamNode)element).getKind();
                if ((this.showMask & 8) == 0 && (kind & 0x10) != 0) {
                    return false;
                }
                int change = ((ITeamNode)element).getKind() & 3;
                int direction = ((ITeamNode)element).getChangeDirection();
                switch (direction) {
                    case 8: {
                        return (this.showMask & 1) != 0;
                    }
                    case 4: {
                        return (this.showMask & 2) != 0;
                    }
                    case 12: {
                        return (this.showMask & 4) != 0;
                    }
                }
                return change != 0;
            }
            return false;
        }

        public boolean isFilterProperty(Object element, String property) {
            return property.equals(CatchupReleaseViewer.PROP_KIND);
        }
    }

    class FilterAction
    extends Action {
        FilterAction(String title, ImageDescriptor image) {
            super(title, image);
        }

        public void run() {
            CatchupReleaseViewer.this.updateFilters();
        }
    }

    class SyncSorter
    extends ViewerSorter {
        SyncSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            boolean oneIsFile = e1 instanceof TeamFile;
            boolean twoIsFile = e2 instanceof TeamFile;
            if (oneIsFile != twoIsFile) {
                return oneIsFile ? 1 : -1;
            }
            return super.compare(viewer, e1, e2);
        }
    }

    class RemoveFromTreeAction
    extends Action {
        public RemoveFromTreeAction(String title, ImageDescriptor image) {
            super(title, image);
        }

        public void run() {
            ISelection s = CatchupReleaseViewer.this.getSelection();
            if (!(s instanceof IStructuredSelection) || s.isEmpty()) {
                return;
            }
            Iterator it = ((IStructuredSelection)s).iterator();
            while (it.hasNext()) {
                Object element = it.next();
                CatchupReleaseViewer.this.setAllChildrenInSync((IDiffElement)element);
            }
            CatchupReleaseViewer.this.refresh();
        }

        public void update() {
            this.setEnabled(!CatchupReleaseViewer.this.getSelection().isEmpty());
        }
    }

    class ExpandAllAction
    extends Action {
        public ExpandAllAction(String title, ImageDescriptor image) {
            super(title, image);
        }

        public void run() {
            CatchupReleaseViewer.this.expandSelection();
        }

        public void update() {
            this.setEnabled(!CatchupReleaseViewer.this.getSelection().isEmpty());
        }
    }

    class OpenAction
    extends Action {
        public OpenAction(String title, ImageDescriptor image) {
            super(title, image);
        }

        public void run() {
            CatchupReleaseViewer.this.openSelection();
        }

        public void update() {
            IStructuredSelection ss;
            ISelection selection = CatchupReleaseViewer.this.getSelection();
            if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
                Object element = ss.getFirstElement();
                this.setEnabled(element instanceof TeamFile);
                return;
            }
            this.setEnabled(false);
        }
    }
}

