/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.team.core.IFileTypeInfo;
import org.eclipse.team.core.Team;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class TextPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String TEXT = Policy.bind("TextPreferencePage.text");
    private static final String BINARY = Policy.bind("TextPreferencePage.binary");
    private List input;
    private TableViewer viewer;
    private Button removeButton;
    private Button changeButton;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.team.ui.file_type_preference_page_context");
        Label l1 = new Label(parent, 0);
        l1.setText(Policy.bind("TextPreferencePage.description"));
        GridData data = new GridData(2);
        data.horizontalSpan = 2;
        l1.setLayoutData((Object)data);
        this.viewer = new TableViewer(parent, 68354);
        Table table = this.viewer.getTable();
        new TableEditor(table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(30);
        gd.heightHint = 100;
        table.setLayoutData((Object)gd);
        table.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TextPreferencePage.this.handleSelection();
            }
        });
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        TableColumn[] columns = table.getColumns();
        columns[0].setText(Policy.bind("TextPreferencePage.extension"));
        columns[1].setText(Policy.bind("TextPreferencePage.contents"));
        ComboBoxCellEditor editor = new ComboBoxCellEditor((Composite)table, new String[]{TEXT, BINARY});
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = editor;
        this.viewer.setCellEditors(cellEditorArray);
        this.viewer.setColumnProperties(new String[]{"extension", "contents"});
        this.viewer.setCellModifier(new ICellModifier(){

            public Object getValue(Object element, String property) {
                String value = ((TableEntry)element).getValue();
                if (value.equals(TEXT)) {
                    return new Integer(0);
                }
                return new Integer(1);
            }

            public boolean canModify(Object element, String property) {
                return true;
            }

            public void modify(Object element, String property, Object value) {
                IStructuredSelection selection = (IStructuredSelection)TextPreferencePage.this.viewer.getSelection();
                TableEntry entry = (TableEntry)selection.getFirstElement();
                if ((Integer)value == 0) {
                    entry.setValue(TEXT);
                } else {
                    entry.setValue(BINARY);
                }
                TextPreferencePage.this.viewer.refresh((Object)entry);
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement == null) {
                    return null;
                }
                return ((List)inputElement).toArray();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection == null || !(selection instanceof IStructuredSelection)) {
                    return;
                }
                TextPreferencePage.this.viewer.editElement(((IStructuredSelection)selection).getFirstElement(), 1);
            }
        });
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TableEntry entry1 = (TableEntry)e1;
                TableEntry entry2 = (TableEntry)e2;
                return super.compare(viewer, (Object)entry1.getExtension(), (Object)entry2.getExtension());
            }
        });
        TableLayout tl = new TableLayout();
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        table.setLayout((Layout)tl);
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        Button addButton = new Button(buttons, 8);
        addButton.setText(Policy.bind("TextPreferencePage.add"));
        data = new GridData();
        data.horizontalAlignment = 4;
        data.heightHint = this.convertVerticalDLUsToPixels(14);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, addButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        addButton.setLayoutData((Object)data);
        addButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TextPreferencePage.this.addPattern();
            }
        });
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText(Policy.bind("TextPreferencePage.remove"));
        data = new GridData();
        data.horizontalAlignment = 4;
        data.heightHint = this.convertVerticalDLUsToPixels(14);
        widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.removeButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.removeButton.setLayoutData((Object)data);
        this.removeButton.setEnabled(false);
        this.removeButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TextPreferencePage.this.removePattern();
            }
        });
        this.changeButton = new Button(buttons, 8);
        this.changeButton.setText(Policy.bind("TextPreferencePage.change"));
        data = new GridData();
        data.horizontalAlignment = 4;
        data.heightHint = this.convertVerticalDLUsToPixels(14);
        widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.changeButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.changeButton.setLayoutData((Object)data);
        this.changeButton.setEnabled(false);
        this.changeButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TextPreferencePage.this.changePattern();
            }
        });
        this.fillTable(Team.getAllTypes());
        Dialog.applyDialogFont((Control)parent);
        return parent;
    }

    protected void performDefaults() {
        super.performDefaults();
        IFileTypeInfo[] infos = Team.getDefaultTypes();
        this.fillTable(infos);
    }

    public boolean performOk() {
        int size = this.input.size();
        String[] extensions = new String[size];
        int[] types = new int[size];
        int i = 0;
        Iterator it = this.input.iterator();
        while (it.hasNext()) {
            TableEntry entry = (TableEntry)it.next();
            String value = entry.getValue();
            types[i] = value.equals(TEXT) ? 1 : 2;
            extensions[i] = entry.getExtension();
            ++i;
        }
        Team.setAllTypes((String[])extensions, (int[])types);
        return true;
    }

    private void fillTable(IFileTypeInfo[] infos) {
        this.input = new ArrayList();
        int i = 0;
        while (i < infos.length) {
            IFileTypeInfo info = infos[i];
            int type = info.getType();
            switch (type) {
                case 1: {
                    this.input.add(new TableEntry(info.getExtension(), TEXT));
                    break;
                }
                case 2: {
                    this.input.add(new TableEntry(info.getExtension(), BINARY));
                }
            }
            ++i;
        }
        this.viewer.setInput((Object)this.input);
    }

    private void addPattern() {
        InputDialog dialog = new InputDialog(this.getShell(), Policy.bind("TextPreferencePage.enterExtensionShort"), Policy.bind("TextPreferencePage.enterExtensionLong"), null, null);
        dialog.open();
        if (dialog.getReturnCode() != 0) {
            return;
        }
        String pattern = dialog.getValue();
        if (pattern.equals("")) {
            return;
        }
        Iterator it = this.input.iterator();
        while (it.hasNext()) {
            TableEntry entry = (TableEntry)it.next();
            if (!entry.getExtension().equals(pattern)) continue;
            MessageDialog.openWarning((Shell)this.getShell(), (String)Policy.bind("TextPreferencePage.extensionExistsShort"), (String)Policy.bind("TextPreferencePage.extensionExistsLong"));
            return;
        }
        this.input.add(new TableEntry(pattern, TEXT));
        this.viewer.refresh();
    }

    private void removePattern() {
        ISelection selection = this.viewer.getSelection();
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        Iterator it = ss.iterator();
        while (it.hasNext()) {
            TableEntry entry = (TableEntry)it.next();
            this.input.remove(entry);
        }
        this.viewer.refresh();
    }

    private void changePattern() {
        ISelection selection = this.viewer.getSelection();
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        Iterator it = ss.iterator();
        while (it.hasNext()) {
            TableEntry entry = (TableEntry)it.next();
            String string = entry.getValue();
            if (string.equals(TEXT)) {
                entry.setValue(BINARY);
            } else {
                entry.setValue(TEXT);
            }
            this.viewer.refresh((Object)entry);
        }
    }

    private void handleSelection() {
        boolean empty = this.viewer.getSelection().isEmpty();
        this.removeButton.setEnabled(!empty);
        this.changeButton.setEnabled(!empty);
    }

    class TableEntry {
        String ext;
        String value;

        public TableEntry(String ext, String value) {
            this.ext = ext;
            this.value = value;
        }

        public String getExtension() {
            return this.ext;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            TableEntry entry = (TableEntry)element;
            switch (columnIndex) {
                case 0: {
                    return entry.getExtension();
                }
                case 1: {
                    return entry.getValue();
                }
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

