/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.jobs;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.team.core.subscribers.TeamSubscriber;

public class RefreshSubscriberJob
extends WorkspaceJob {
    private static final Object FAMILY_ID = new Object();
    private boolean reschedule = false;
    boolean restartOnCancel = true;
    static long scheduleDelay = 20000L;
    protected long lastTimeRun = 0L;
    private IResource[] resources;
    private TeamSubscriber subscriber;

    public RefreshSubscriberJob(String name, IResource[] resources, TeamSubscriber subscriber) {
        super(name);
        this.resources = resources;
        this.subscriber = subscriber;
        this.setPriority(50);
        this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (RefreshSubscriberJob.this.shouldReschedule()) {
                    if (event.getResult().getSeverity() == 8 && !RefreshSubscriberJob.this.restartOnCancel) {
                        return;
                    }
                    RefreshSubscriberJob.this.schedule(scheduleDelay);
                    RefreshSubscriberJob.this.restartOnCancel = true;
                }
            }
        });
    }

    public boolean shouldRun() {
        return this.getSubscriber() != null;
    }

    public boolean belongsTo(Object family) {
        return family == RefreshSubscriberJob.getFamily();
    }

    public static Object getFamily() {
        return FAMILY_ID;
    }

    /*
     * Exception decompiling
     */
    public IStatus runInWorkspace(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 7[TRYBLOCK] [4 : 153->156)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected IResource[] getResources() {
        return this.resources;
    }

    protected TeamSubscriber getSubscriber() {
        return this.subscriber;
    }

    public long getScheduleDelay() {
        return scheduleDelay;
    }

    protected void start() {
        if (this.getState() == 0 && this.shouldReschedule()) {
            this.schedule(this.getScheduleDelay());
        }
    }

    public void setRefreshInterval(long seconds) {
        boolean restart = false;
        if (this.getState() == 1) {
            restart = true;
            this.cancel();
        }
        scheduleDelay = seconds * 1000L;
        if (restart) {
            this.start();
        }
    }

    public long getRefreshInterval() {
        return scheduleDelay / 1000L;
    }

    public void setRestartOnCancel(boolean restartOnCancel) {
        this.restartOnCancel = restartOnCancel;
    }

    public void setReschedule(boolean reschedule) {
        this.reschedule = reschedule;
    }

    public boolean shouldReschedule() {
        return this.reschedule;
    }

    public long getLastTimeRun() {
        return this.lastTimeRun;
    }
}

