/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.jobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.team.internal.ui.jobs.IJobListener;

public class JobStatusHandler
extends JobChangeAdapter {
    private static Map handlers = new HashMap();
    private QualifiedName jobType;
    private Set jobs = new HashSet();
    private List listeners = new ArrayList();

    public static void schedule(Job job, QualifiedName jobType) {
        JobStatusHandler handler;
        Map map = handlers;
        synchronized (map) {
            handler = JobStatusHandler.getHandler(jobType);
            if (handler == null) {
                handler = JobStatusHandler.createHandler(jobType);
            }
        }
        handler.schedule(job);
    }

    public static void addJobListener(IJobListener listener, QualifiedName jobType) {
        Map map = handlers;
        synchronized (map) {
            JobStatusHandler handler = JobStatusHandler.getHandler(jobType);
            if (handler == null) {
                handler = JobStatusHandler.createHandler(jobType);
            }
            handler.addJobListener(listener);
        }
    }

    public static void removeJobListener(IJobListener listener, QualifiedName jobType) {
        Map map = handlers;
        synchronized (map) {
            JobStatusHandler handler = JobStatusHandler.getHandler(jobType);
            if (handler != null) {
                handler.removeJobListener(listener);
            }
        }
    }

    public static boolean hasRunningJobs(QualifiedName jobType) {
        JobStatusHandler handler = JobStatusHandler.getHandler(jobType);
        if (handler != null) {
            return handler.hasRunningJobs();
        }
        return false;
    }

    private static JobStatusHandler getHandler(QualifiedName jobType) {
        return (JobStatusHandler)((Object)handlers.get(jobType));
    }

    private static JobStatusHandler createHandler(QualifiedName jobType) {
        JobStatusHandler existing = JobStatusHandler.getHandler(jobType);
        if (existing != null) {
            return existing;
        }
        JobStatusHandler newHandler = new JobStatusHandler(jobType);
        handlers.put(jobType, newHandler);
        return newHandler;
    }

    protected JobStatusHandler(QualifiedName jobType) {
        this.jobType = jobType;
    }

    public void schedule(Job job) {
        job.addJobChangeListener((IJobChangeListener)this);
        job.schedule();
    }

    public void done(IJobChangeEvent event) {
        this.jobDone(event.getJob());
    }

    public void addJobListener(IJobListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    public void removeJobListener(IJobListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    private void fireNotification(Notification notification) {
        IJobListener[] listenerArray;
        List list = this.listeners;
        synchronized (list) {
            listenerArray = this.listeners.toArray(new IJobListener[this.listeners.size()]);
        }
        int i = 0;
        while (i < listenerArray.length) {
            IJobListener listener = listenerArray[i];
            notification.run(listener);
            ++i;
        }
    }

    private void jobStarted(Job job) {
        if (this.recordJob(job)) {
            this.fireStartNotification();
        }
    }

    private boolean recordJob(Job job) {
        if (!this.jobs.add(job)) {
            return false;
        }
        return this.jobs.size() == 1;
    }

    private boolean removeJob(Job job) {
        if (!this.jobs.remove(job)) {
            return false;
        }
        return this.jobs.isEmpty();
    }

    private void fireStartNotification() {
        this.fireNotification(new Notification(){

            public void notify(IJobListener listener) {
                listener.started(JobStatusHandler.this.getJobType());
            }
        });
    }

    private void jobDone(Job job) {
        if (this.removeJob(job)) {
            this.fireEndNotification();
        }
    }

    private void fireEndNotification() {
        this.fireNotification(new Notification(){

            public void notify(IJobListener listener) {
                listener.finished(JobStatusHandler.this.getJobType());
            }
        });
    }

    public boolean hasRunningJobs() {
        return !this.jobs.isEmpty();
    }

    public QualifiedName getJobType() {
        return this.jobType;
    }

    public void aboutToRun(IJobChangeEvent event) {
        this.jobStarted(event.getJob());
    }

    private abstract class Notification
    implements ISafeRunnable {
        private IJobListener listener;

        Notification() {
        }

        public void handleException(Throwable exception) {
        }

        public void run(IJobListener listener) {
            this.listener = listener;
            Platform.run((ISafeRunnable)this);
        }

        public void run() throws Exception {
            this.notify(this.listener);
        }

        protected abstract void notify(IJobListener var1);
    }
}

