/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.jobs;

import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.internal.ui.jobs.IJobListener;
import org.eclipse.team.internal.ui.jobs.JobStatusHandler;

public class JobBusyCursor
implements IJobListener {
    private Composite composite;
    private Cursor waitCursor;
    private QualifiedName jobType;

    public JobBusyCursor(Composite composite, QualifiedName jobType) {
        this.composite = composite;
        this.jobType = jobType;
        JobBusyCursor jobBusyCursor = this;
        synchronized (jobBusyCursor) {
            JobStatusHandler.addJobListener(this, jobType);
        }
    }

    private Cursor getWaitCursor() {
        if (this.waitCursor == null) {
            Display display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            this.waitCursor = new Cursor((Device)display, 3);
        }
        return this.waitCursor;
    }

    private void showCursor(final Cursor cursor) {
        if (this.getComposite() == null || cursor != null && cursor.isDisposed()) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (cursor != null && cursor.isDisposed()) {
                        return;
                    }
                    JobBusyCursor.this.setCursorDeep(cursor, (Control)JobBusyCursor.this.getComposite());
                }
            }
        });
    }

    private void setCursorDeep(Cursor cursor, Control control) {
        if (control != null && !control.isDisposed()) {
            control.setCursor(cursor);
            if (control instanceof Composite) {
                Composite composite = (Composite)control;
                Control[] children = composite.getChildren();
                int i = 0;
                while (i < children.length) {
                    this.setCursorDeep(cursor, children[i]);
                    ++i;
                }
            }
        }
    }

    public synchronized void dispose() {
        if (this.waitCursor != null) {
            this.waitCursor.dispose();
        }
        JobStatusHandler.removeJobListener(this, this.jobType);
    }

    private void showBusyCursor() {
        this.showCursor(this.getWaitCursor());
    }

    public void started(QualifiedName jobType) {
        this.showBusyCursor();
    }

    public void finished(QualifiedName jobType) {
        this.showCursor(null);
    }

    public Composite getComposite() {
        return this.composite;
    }
}

