/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.dialogs;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;

public class PreferencePageContainerDialog
extends Dialog
implements IPreferencePageContainer {
    PreferencePage page;
    private Composite fTitleArea;
    private Label fTitleImage;
    private CLabel fMessageLabel;
    private String fMessage;
    private Color fNormalMsgAreaBackground;
    private Image fErrorMsgImage;
    private Button fOkButton;
    protected static final String PREF_DLG_TITLE_IMG = "preference_page_container_image";
    protected static final String PREF_DLG_IMG_TITLE_ERROR = "preference_page_container_title_error_image";
    private Composite fPageContainer;
    private Point fMinimumPageSize = new Point(200, 200);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        ImageRegistry reg = TeamUIPlugin.getPlugin().getImageRegistry();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.jface.preference.PreferenceDialog;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        reg.put(PREF_DLG_TITLE_IMG, ImageDescriptor.createFromFile((Class)clazz, (String)"images/pref_dialog_title.gif"));
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Lorg.eclipse.jface.dialogs.Dialog;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        reg.put(PREF_DLG_IMG_TITLE_ERROR, ImageDescriptor.createFromFile((Class)clazz2, (String)"images/message_error.gif"));
    }

    public PreferencePageContainerDialog(Shell shell, PreferencePage page) {
        super(shell);
        this.page = page;
    }

    protected void okPressed() {
        final ArrayList changedProperties = new ArrayList(5);
        this.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                changedProperties.add(event.getProperty());
            }
        });
        this.page.performOk();
        this.handleSave();
        super.okPressed();
    }

    public void setTitle(String title) {
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.setText(title);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 1;
        Composite titleComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        titleComposite.setLayout((Layout)layout);
        titleComposite.setLayoutData((Object)new GridData(768));
        this.createTitleArea(titleComposite);
        Label titleBarSeparator = new Label(titleComposite, 258);
        GridData gd = new GridData(768);
        titleBarSeparator.setLayoutData((Object)gd);
        this.fPageContainer = this.createPageContainer(composite);
        this.fPageContainer.setLayoutData((Object)new GridData(1808));
        this.page.setContainer((IPreferencePageContainer)this);
        this.page.createControl(this.fPageContainer);
        this.setTitle(this.page.getTitle());
        Label separator = new Label(composite, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        separator.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    private Composite createTitleArea(Composite parent) {
        parent.getFont();
        this.fTitleArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.numColumns = 2;
        Display display = parent.getDisplay();
        Color bg = JFaceColors.getBannerBackground((Display)display);
        Color fg = JFaceColors.getBannerForeground((Display)display);
        GridData layoutData = new GridData(1808);
        this.fTitleArea.setLayout((Layout)layout);
        this.fTitleArea.setLayoutData((Object)layoutData);
        this.fTitleArea.setBackground(bg);
        this.fMessageLabel = new CLabel(this.fTitleArea, 16384);
        this.fMessageLabel.setBackground(bg);
        this.fMessageLabel.setForeground(fg);
        this.fMessageLabel.setText(" ");
        this.fMessageLabel.setFont(JFaceResources.getBannerFont());
        final IPropertyChangeListener fontListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("org.eclipse.jface.bannerfont".equals(event.getProperty()) || "org.eclipse.jface.dialogfont".equals(event.getProperty())) {
                    PreferencePageContainerDialog.this.updateMessage();
                }
            }
        };
        this.fMessageLabel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                JFaceResources.getFontRegistry().removeListener(fontListener);
            }
        });
        JFaceResources.getFontRegistry().addListener(fontListener);
        GridData gd = new GridData(1808);
        this.fMessageLabel.setLayoutData((Object)gd);
        this.fTitleImage = new Label(this.fTitleArea, 16384);
        this.fTitleImage.setBackground(bg);
        this.fTitleImage.setImage(TeamUIPlugin.getPlugin().getImageRegistry().get(PREF_DLG_TITLE_IMG));
        gd = new GridData();
        gd.horizontalAlignment = 3;
        this.fTitleImage.setLayoutData((Object)gd);
        return this.fTitleArea;
    }

    private Composite createPageContainer(Composite parent) {
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)new PageLayout());
        return result;
    }

    public void setMinimumPageSize(Point size) {
        this.fMinimumPageSize.x = size.x;
        this.fMinimumPageSize.y = size.y;
    }

    public void setErrorMessage(String errorMessage) {
        if (errorMessage == null) {
            if (this.fMessageLabel.getImage() != null) {
                this.fMessageLabel.setBackground(this.fNormalMsgAreaBackground);
                this.fMessageLabel.setImage(null);
                this.fTitleImage.setImage(TeamUIPlugin.getPlugin().getImageRegistry().get(PREF_DLG_TITLE_IMG));
                this.fTitleArea.layout(true);
            }
            this.setMessage(this.fMessage);
        } else {
            this.fMessageLabel.setText(errorMessage);
            if (this.fMessageLabel.getImage() == null) {
                if (this.fErrorMsgImage == null) {
                    this.fErrorMsgImage = TeamUIPlugin.getPlugin().getImageRegistry().get(PREF_DLG_IMG_TITLE_ERROR);
                }
                this.fNormalMsgAreaBackground = this.fMessageLabel.getBackground();
                this.fMessageLabel.setBackground(JFaceColors.getErrorBackground((Display)this.fMessageLabel.getDisplay()));
                this.fMessageLabel.setImage(this.fErrorMsgImage);
                this.fTitleImage.setImage(null);
                this.fTitleArea.layout(true);
            }
        }
    }

    public void setMessage(String newMessage) {
        this.fMessage = newMessage;
        if (this.fMessage == null) {
            this.fMessage = "";
        }
        if (this.fMessageLabel.getImage() == null) {
            this.fMessageLabel.setText(this.fMessage);
        }
    }

    public void updateMessage() {
        String pageMessage = this.page.getMessage();
        String pageErrorMessage = this.page.getErrorMessage();
        if (pageMessage == null && pageErrorMessage == null) {
            this.fMessageLabel.setFont(JFaceResources.getBannerFont());
        } else {
            this.fMessageLabel.setFont(JFaceResources.getDialogFont());
        }
        if (pageMessage == null) {
            this.setMessage(this.page.getTitle());
        } else {
            this.setMessage(pageMessage);
        }
        this.setErrorMessage(pageErrorMessage);
    }

    public IPreferenceStore getPreferenceStore() {
        return this.page.getPreferenceStore();
    }

    public void updateButtons() {
        if (this.fOkButton != null) {
            this.fOkButton.setEnabled(this.page.isValid());
        }
    }

    public void updateTitle() {
        this.setTitle(this.page.getTitle());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.fOkButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void handleSave() {
        IPreferenceStore store;
        if (this.page instanceof PreferencePage && (store = this.page.getPreferenceStore()) != null && store.needsSaving() && store instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)store).save();
            }
            catch (IOException e) {
                Utils.handle(e);
            }
        }
    }

    private class PageLayout
    extends Layout {
        PageLayout() {
        }

        public void layout(Composite composite, boolean force) {
            Rectangle rect = composite.getClientArea();
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].setSize(rect.width, rect.height);
                ++i;
            }
        }

        public Point computeSize(Composite composite, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            int x = ((PreferencePageContainerDialog)PreferencePageContainerDialog.this).fMinimumPageSize.x;
            int y = ((PreferencePageContainerDialog)PreferencePageContainerDialog.this).fMinimumPageSize.y;
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                Point size = children[i].computeSize(-1, -1, force);
                x = Math.max(x, size.x);
                y = Math.max(y, size.y);
                ++i;
            }
            if (wHint != -1) {
                x = wHint;
            }
            if (hHint != -1) {
                y = hHint;
            }
            return new Point(x, y);
        }
    }
}

