/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.ui.TeamImages;

public class Utils {
    public static void handleError(Shell shell, Exception exception, String title, String message) {
        IStatus status = null;
        boolean log = false;
        boolean dialog = false;
        Throwable t = exception;
        if (exception instanceof TeamException) {
            status = ((TeamException)((Object)exception)).getStatus();
            log = false;
            dialog = true;
        } else if (exception instanceof InvocationTargetException) {
            t = ((InvocationTargetException)exception).getTargetException();
            if (t instanceof TeamException) {
                status = ((TeamException)t).getStatus();
                log = false;
                dialog = true;
            } else if (t instanceof CoreException) {
                status = ((CoreException)t).getStatus();
                log = true;
                dialog = true;
            } else {
                if (t instanceof InterruptedException) {
                    return;
                }
                status = new Status(4, "org.eclipse.team.ui", 1, Policy.bind("TeamAction.internal"), t);
                log = true;
                dialog = true;
            }
        }
        if (status == null) {
            return;
        }
        if (!status.isOK()) {
            IStatus[] children;
            IStatus toShow = status;
            if (status.isMultiStatus() && (children = status.getChildren()).length == 1) {
                toShow = children[0];
            }
            if (title == null) {
                title = status.getMessage();
            }
            if (message == null) {
                message = status.getMessage();
            }
            if (dialog && shell != null) {
                ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)toShow);
            }
            if (log || shell == null) {
                TeamUIPlugin.log(toShow.getSeverity(), message, t);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static void runWithProgress(Shell parent, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 141->145)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void runWithProgressDialog(Shell parent, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        new ProgressMonitorDialog(parent).run(cancelable, cancelable, runnable);
    }

    public static void handle(Throwable t) {
        Object error = null;
        if (t instanceof InvocationTargetException) {
            t = ((InvocationTargetException)t).getTargetException();
        }
        error = t instanceof CoreException ? ((CoreException)t).getStatus() : (t instanceof TeamException ? ((TeamException)t).getStatus() : new Status(4, "org.eclipse.team.ui", 1, Policy.bind("simpleInternal"), t));
        Shell shell = new Shell(Display.getDefault());
        if (error.getSeverity() == 1) {
            MessageDialog.openInformation((Shell)shell, (String)Policy.bind("information"), (String)error.getMessage());
        } else {
            ErrorDialog.openError((Shell)shell, (String)Policy.bind("exception"), null, (IStatus)error);
        }
        shell.dispose();
        if (!(t instanceof TeamException)) {
            TeamUIPlugin.log(error.getSeverity(), error.getMessage(), t);
        }
    }

    public static void initAction(IAction a, String prefix) {
        Utils.initAction(a, prefix, Policy.bundle);
    }

    public static void initAction(IAction a, String prefix, ResourceBundle bundle) {
        String relPath;
        String s;
        String labelKey = "label";
        String tooltipKey = "tooltip";
        String imageKey = "image";
        String descriptionKey = "description";
        if (prefix != null && prefix.length() > 0) {
            labelKey = String.valueOf(prefix) + labelKey;
            tooltipKey = String.valueOf(prefix) + tooltipKey;
            imageKey = String.valueOf(prefix) + imageKey;
            descriptionKey = String.valueOf(prefix) + descriptionKey;
        }
        if ((s = Policy.bind(labelKey, bundle)) != null) {
            a.setText(s);
        }
        if ((s = Policy.bind(tooltipKey, bundle)) != null) {
            a.setToolTipText(s);
        }
        if ((s = Policy.bind(descriptionKey, bundle)) != null) {
            a.setDescription(s);
        }
        if ((relPath = Policy.bind(imageKey, bundle)) != null && !relPath.equals(imageKey) && relPath.trim().length() > 0) {
            String ePath;
            String dPath;
            String cPath;
            if (relPath.indexOf("/") >= 0) {
                String path = relPath.substring(1);
                cPath = String.valueOf('c') + path;
                dPath = String.valueOf('d') + path;
                ePath = String.valueOf('e') + path;
            } else {
                cPath = "clcl16/" + relPath;
                dPath = "dlcl16/" + relPath;
                ePath = "elcl16/" + relPath;
            }
            ImageDescriptor id = TeamImages.getImageDescriptor(dPath);
            if (id != null) {
                a.setDisabledImageDescriptor(id);
            }
            if ((id = TeamUIPlugin.getImageDescriptor(cPath)) != null) {
                a.setHoverImageDescriptor(id);
            }
            if ((id = TeamUIPlugin.getImageDescriptor(ePath)) != null) {
                a.setImageDescriptor(id);
            }
        }
    }

    public static abstract class Sorter {
        public abstract boolean compare(Object var1, Object var2);

        private Object[] quickSort(Object[] sortedCollection, int left, int right) {
            int originalLeft = left;
            int originalRight = right;
            Object mid = sortedCollection[(left + right) / 2];
            while (true) {
                if (this.compare(sortedCollection[left], mid)) {
                    ++left;
                    continue;
                }
                while (this.compare(mid, sortedCollection[right])) {
                    --right;
                }
                if (left <= right) {
                    Object tmp = sortedCollection[left];
                    sortedCollection[left] = sortedCollection[right];
                    sortedCollection[right] = tmp;
                    ++left;
                    --right;
                }
                if (left > right) break;
            }
            if (originalLeft < right) {
                sortedCollection = this.quickSort(sortedCollection, originalLeft, right);
            }
            if (left < originalRight) {
                sortedCollection = this.quickSort(sortedCollection, left, originalRight);
            }
            return sortedCollection;
        }

        public Object[] sort(Object[] unSortedCollection) {
            int size = unSortedCollection.length;
            Object[] sortedCollection = new Object[size];
            System.arraycopy(unSortedCollection, 0, sortedCollection, 0, size);
            if (size > 1) {
                this.quickSort(sortedCollection, 0, size - 1);
            }
            return sortedCollection;
        }
    }
}

