/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.jobs.RefreshSubscriberInputJob;
import org.eclipse.team.internal.ui.synchronize.SynchronizeManager;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TeamUIPlugin
extends AbstractUIPlugin
implements IPropertyChangeListener {
    private static TeamUIPlugin instance;
    public static final String ICON_PATH = "icons/full/";
    public static final String ID = "org.eclipse.team.ui";
    public static final String PT_SUBSCRIBER_MENUS = "subscriberMenus";
    public static final String PLUGIN_ID = "org.eclipse.team.ui";
    private static List propertyChangeListeners;
    private Hashtable imageDescriptors = new Hashtable(20);
    private static List disposeOnShutdownImages;
    private RefreshSubscriberInputJob refreshJob;

    static {
        propertyChangeListeners = new ArrayList(5);
        disposeOnShutdownImages = new ArrayList();
    }

    public RefreshSubscriberInputJob getRefreshJob() {
        return this.refreshJob;
    }

    public TeamUIPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        instance = this;
        this.initializeImages();
        this.initializePreferences();
    }

    public static Object createExtension(final IConfigurationElement element, final String classAttribute) throws CoreException {
        IPluginDescriptor plugin = element.getDeclaringExtension().getDeclaringPluginDescriptor();
        if (plugin.isPluginActivated()) {
            return element.createExecutableExtension(classAttribute);
        }
        final Object[] ret = new Object[1];
        final CoreException[] exc = new CoreException[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                try {
                    ret[0] = element.createExecutableExtension(classAttribute);
                }
                catch (CoreException e) {
                    exc[0] = e;
                }
            }
        });
        if (exc[0] != null) {
            throw exc[0];
        }
        return ret[0];
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = TeamUIPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    public static TeamUIPlugin getPlugin() {
        while (instance == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return instance;
    }

    protected void initializePreferences() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setDefault("org.eclipse.team.ui.background_sync", true);
        store.setDefault("org.eclipse.team.ui.scheduled_sync", false);
        store.setDefault("org.eclipse.team.ui.view_syncinfo_in_label", false);
        store.setDefault("org.eclipse.team.ui.scheduled_sync_delay", 60);
        store.setDefault("org.eclipse.team.ui.compress_folders", true);
        store.setDefault("org.eclipse.team.ui.table_column_sort", 0);
        store.setDefault("org.eclipse.team.ui.table_column_sort_reversed", false);
        store.setDefault("org.eclipse.team.ui.syncview_selected_mode", 4);
        store.setDefault("org.eclipse.team.ui.syncview_default_perspective", "org.eclipse.team.ui.TeamSynchronizingPerspective");
    }

    public static void log(IStatus status) {
        TeamUIPlugin.getPlugin().getLog().log(status);
    }

    public static void log(CoreException e) {
        IStatus status = e.getStatus();
        TeamUIPlugin.log(status.getSeverity(), status.getMessage(), e);
    }

    public static void log(int severity, String message, Throwable e) {
        TeamUIPlugin.log((IStatus)new Status(severity, "org.eclipse.team.ui", 0, message, e));
    }

    public void startup() throws CoreException {
        Policy.localize("org.eclipse.team.internal.ui.messages");
        this.initializePreferences();
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.refreshJob = new RefreshSubscriberInputJob(Policy.bind("ScheduledSyncViewRefresh.taskName"));
        this.refreshJob.setRefreshInterval(this.getPreferenceStore().getInt("org.eclipse.team.ui.scheduled_sync_delay") * 60);
        if (this.getPreferenceStore().getBoolean("org.eclipse.team.ui.scheduled_sync")) {
            this.refreshJob.setRestartOnCancel(true);
            this.refreshJob.setReschedule(true);
            this.refreshJob.schedule(this.refreshJob.getScheduleDelay());
        }
        ((SynchronizeManager)TeamUI.getSynchronizeManager()).init();
    }

    public void shutdown() throws CoreException {
        super.shutdown();
        TeamUIPlugin.disposeImages();
        ((SynchronizeManager)TeamUI.getSynchronizeManager()).dispose();
    }

    public static void addPropertyChangeListener(IPropertyChangeListener listener) {
        propertyChangeListeners.add(listener);
    }

    public static void removePropertyChangeListener(IPropertyChangeListener listener) {
        propertyChangeListeners.remove(listener);
    }

    public static void broadcastPropertyChange(PropertyChangeEvent event) {
        Iterator it = propertyChangeListeners.iterator();
        while (it.hasNext()) {
            IPropertyChangeListener listener = (IPropertyChangeListener)it.next();
            listener.propertyChange(event);
        }
    }

    public static void disposeOnShutdown(Image image) {
        if (image != null) {
            disposeOnShutdownImages.add(image);
        }
    }

    protected static void createImageDescriptor(String id, URL baseURL) {
        TeamUIPlugin.getPlugin().privateCreateImageDescriptor(id, baseURL);
    }

    private void privateCreateImageDescriptor(String id, URL baseURL) {
        URL url = null;
        try {
            url = new URL(baseURL, ICON_PATH + id);
        }
        catch (MalformedURLException malformedURLException) {}
        ImageDescriptor desc = ImageDescriptor.createFromURL(url);
        this.imageDescriptors.put(id, desc);
    }

    public static ImageDescriptor getImageDescriptor(String id) {
        return TeamUIPlugin.getPlugin().privateGetImageDescriptor(id);
    }

    private ImageDescriptor privateGetImageDescriptor(String id) {
        if (!this.imageDescriptors.containsKey(id)) {
            URL baseURL = TeamUIPlugin.getPlugin().getDescriptor().getInstallURL();
            TeamUIPlugin.createImageDescriptor(id, baseURL);
        }
        return (ImageDescriptor)this.imageDescriptors.get(id);
    }

    public static ImageDescriptor getImageDescriptorFromExtension(IExtension extension, String subdirectoryAndFilename) {
        IPluginDescriptor pluginDescriptor = extension.getDeclaringPluginDescriptor();
        URL path = pluginDescriptor.getInstallURL();
        URL fullPathString = null;
        try {
            fullPathString = new URL(path, subdirectoryAndFilename);
            return ImageDescriptor.createFromURL((URL)fullPathString);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private void initializeImages() {
        URL baseURL = TeamUIPlugin.getPlugin().getDescriptor().getInstallURL();
        TeamUIPlugin.createImageDescriptor("ovr/dirty_ov.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("ovr/confchg_ov.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("ovr/version_controlled.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("ovr/checkedout_ov.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("cview16/synch_synch.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("clcl16/collapseall.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("elcl16/collapseall.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("clcl16/site_element.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("clcl16/incom_synch.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("clcl16/outgo_synch.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("clcl16/conflict_synch.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("clcl16/refresh.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("clcl16/change_filter.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("clcl16/ignorews_edit.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("clcl16/contents.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("dlcl16/incom_synch.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("dlcl16/outgo_synch.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("dlcl16/conflict_synch.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("dlcl16/refresh.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("dlcl16/ignorews_edit.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("dlcl16/contents.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("elcl16/incom_synch.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("elcl16/outgo_synch.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("elcl16/conflict_synch.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("elcl16/refresh.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("elcl16/ignorews_edit.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("elcl16/contents.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("clcl16/catchup_rls.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("clcl16/release_rls.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("clcl16/catchuprelease_rls.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("dlcl16/catchup_rls.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("dlcl16/release_rls.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("dlcl16/catchuprelease_rls.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("elcl16/catchup_rls.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("elcl16/release_rls.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("elcl16/catchuprelease_rls.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("wizban/share_wizban.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("wizban/import_projectset_wizban.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("wizban/export_projectset_wizban.gif", baseURL);
        TeamUIPlugin.createImageDescriptor("obj/compressed_folder_obj.gif", baseURL);
    }

    public static void disposeImages() {
        TeamUIPlugin.getPlugin().privateDisposeImages();
    }

    private void privateDisposeImages() {
        if (disposeOnShutdownImages != null) {
            Iterator i = disposeOnShutdownImages.iterator();
            while (i.hasNext()) {
                Image img = (Image)i.next();
                if (img.isDisposed()) continue;
                img.dispose();
            }
            this.imageDescriptors = null;
        }
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static void run(IRunnableWithProgress runnable) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            Utils.handleError(TeamUIPlugin.getStandardDisplay().getActiveShell(), e, null, null);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void propertyChange(PropertyChangeEvent event) {
        RefreshSubscriberInputJob refreshJob;
        if (event.getProperty().equals("org.eclipse.team.ui.scheduled_sync_delay")) {
            refreshJob = this.getRefreshJob();
            refreshJob.setRefreshInterval(this.getPreferenceStore().getInt("org.eclipse.team.ui.scheduled_sync_delay") * 60);
        }
        if (event.getProperty().equals("org.eclipse.team.ui.scheduled_sync")) {
            refreshJob = this.getRefreshJob();
            refreshJob.setRefreshInterval(this.getPreferenceStore().getInt("org.eclipse.team.ui.scheduled_sync_delay") * 60);
            boolean value = this.getPreferenceStore().getBoolean("org.eclipse.team.ui.scheduled_sync");
            if (value) {
                refreshJob.setRestartOnCancel(true);
                refreshJob.setReschedule(true);
                refreshJob.schedule(refreshJob.getRefreshInterval() * 1000L);
            } else {
                refreshJob.setRestartOnCancel(false);
                refreshJob.setReschedule(false);
                refreshJob.cancel();
            }
        }
    }
}

