/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class ExceptionCollector {
    private Map exceptionBucket = new HashMap();
    private List statuses = new ArrayList();
    private String message;
    private String pluginId;
    private int severity;
    private ILog log;
    private boolean ignoreDuplicates = false;

    public ExceptionCollector(String message, String pluginId, int severity, ILog log) {
        this.message = message;
        this.pluginId = pluginId;
        this.severity = severity;
        this.log = log;
    }

    public void clear() {
        this.statuses.clear();
        this.exceptionBucket.clear();
    }

    public IStatus getStatus() {
        if (this.statuses.isEmpty()) {
            return Status.OK_STATUS;
        }
        MultiStatus multiStatus = new MultiStatus(this.pluginId, this.severity, this.message, null);
        Iterator it = this.statuses.iterator();
        while (it.hasNext()) {
            IStatus status = (IStatus)it.next();
            multiStatus.merge(status);
        }
        return multiStatus;
    }

    public boolean isIgnoreDuplicates() {
        return this.ignoreDuplicates;
    }

    public void setIgnoreDuplicates(boolean ignoreDuplicates) {
        this.ignoreDuplicates = ignoreDuplicates;
    }

    public void handleException(Exception e) {
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)((Object)e)).getStatus();
        }
        if (status != null) {
            this.logStatus(status);
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                IStatus status2 = children[i];
                this.logStatus(status2);
                ++i;
            }
        }
    }

    private void logStatus(IStatus status) {
        String pluginId = status.getPlugin();
        ArrayList<Integer> codes = (ArrayList<Integer>)this.exceptionBucket.get(pluginId);
        Integer code = new Integer(status.getCode());
        if (codes != null && codes.contains(code) && this.isIgnoreDuplicates()) {
            return;
        }
        this.statuses.add(status);
        codes = new ArrayList<Integer>(1);
        codes.add(code);
        this.exceptionBucket.put(pluginId, codes);
        if (this.log != null) {
            this.log.log((IStatus)new Status(status.getSeverity(), pluginId, status.getCode(), this.message, status.getException()));
        }
    }
}

