/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core.sync;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.sync.ILocalSyncElement;
import org.eclipse.team.core.sync.IRemoteResource;
import org.eclipse.team.core.sync.IRemoteSyncElement;
import org.eclipse.team.core.sync.LocalSyncElement;
import org.eclipse.team.internal.core.Assert;
import org.eclipse.team.internal.core.Policy;

public abstract class RemoteSyncElement
extends LocalSyncElement
implements IRemoteSyncElement {
    public abstract IRemoteSyncElement create(boolean var1, IResource var2, IRemoteResource var3, IRemoteResource var4, Object var5);

    public ILocalSyncElement[] members(IProgressMonitor progress) throws TeamException {
        IResource[] localChildren;
        IRemoteResource remote = this.getRemote();
        IRemoteResource base = this.getBase();
        IResource local = this.getLocal();
        IRemoteResource[] remoteChildren = remote != null ? remote.members(progress) : new IRemoteResource[]{};
        IRemoteResource[] baseChildren = base != null ? base.members(progress) : new IRemoteResource[]{};
        try {
            localChildren = local.getType() != 1 && local.exists() ? ((IContainer)local).members() : new IResource[]{};
        }
        catch (CoreException e) {
            throw new TeamException(e.getStatus());
        }
        if (remoteChildren.length > 0 || localChildren.length > 0) {
            String name;
            int i;
            ArrayList<IRemoteSyncElement> syncChildren = new ArrayList<IRemoteSyncElement>(10);
            HashSet<String> allSet = new HashSet<String>(20);
            HashMap<String, IResource> localSet = null;
            HashMap<String, IRemoteResource> remoteSet = null;
            HashMap<String, IRemoteResource> baseSet = null;
            if (localChildren.length > 0) {
                localSet = new HashMap<String, IResource>(10);
                i = 0;
                while (i < localChildren.length) {
                    IResource localChild = localChildren[i];
                    name = localChild.getName();
                    localSet.put(name, localChild);
                    allSet.add(name);
                    ++i;
                }
            }
            if (remoteChildren.length > 0) {
                remoteSet = new HashMap<String, IRemoteResource>(10);
                i = 0;
                while (i < remoteChildren.length) {
                    IRemoteResource remoteChild = remoteChildren[i];
                    name = remoteChild.getName();
                    remoteSet.put(name, remoteChild);
                    allSet.add(name);
                    ++i;
                }
            }
            if (baseChildren.length > 0) {
                baseSet = new HashMap<String, IRemoteResource>(10);
                i = 0;
                while (i < baseChildren.length) {
                    IRemoteResource baseChild = baseChildren[i];
                    name = baseChild.getName();
                    baseSet.put(name, baseChild);
                    allSet.add(name);
                    ++i;
                }
            }
            Iterator e = allSet.iterator();
            while (e.hasNext()) {
                IRemoteResource baseChild;
                String keyChildName = (String)e.next();
                if (progress != null && progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IResource localChild = localSet != null ? (IResource)localSet.get(keyChildName) : null;
                IRemoteResource remoteChild = remoteSet != null ? (IRemoteResource)remoteSet.get(keyChildName) : null;
                IRemoteResource iRemoteResource = baseChild = baseSet != null ? (IRemoteResource)baseSet.get(keyChildName) : null;
                if (localChild == null) {
                    Assert.isTrue(remoteChild != null || baseChild != null);
                    boolean isContainer = remoteChild != null ? remoteChild.isContainer() : baseChild.isContainer();
                    localChild = this.getResourceChild(local, keyChildName, isContainer);
                }
                if (localChild.exists() && this.isIgnored(localChild)) continue;
                syncChildren.add(this.create(this.isThreeWay(), localChild, baseChild, remoteChild, this.getData()));
            }
            return syncChildren.toArray(new IRemoteSyncElement[syncChildren.size()]);
        }
        return new IRemoteSyncElement[0];
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getSyncKind(int granularity, IProgressMonitor progress) {
        progress = Policy.monitorFor(progress);
        int description = 0;
        IResource local = this.getLocal();
        IRemoteResource remote = this.getRemote();
        IRemoteResource base = this.getBase();
        boolean localExists = this.getLocal().exists();
        if (this.isThreeWay()) {
            if (base == null) {
                if (remote == null) {
                    if (localExists) return 5;
                    Assert.isTrue(false);
                    return description;
                }
                if (!localExists) {
                    return 9;
                }
                description = 13;
                try {
                    progress.beginTask(null, 60);
                    if (this.isGranularityContents(granularity) && this.compare(granularity, true, local, remote, Policy.subMonitorFor(progress, 30))) {
                        description |= 0x10;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    progress.done();
                    throw throwable;
                }
                {
                    Object var8_11 = null;
                    progress.done();
                    return description;
                }
            }
            if (!localExists) {
                if (remote == null) {
                    return 30;
                }
                if (!this.compare(granularity, false, base, remote, progress)) return 15;
                return 6;
            }
            if (remote == null) {
                if (!this.compare(granularity, false, local, base, progress)) return 15;
                return 10;
            }
            progress.beginTask(null, 90);
            boolean ay = this.compare(granularity, false, local, base, Policy.subMonitorFor(progress, 30));
            boolean am = this.compare(granularity, false, base, remote, Policy.subMonitorFor(progress, 30));
            if (!ay || !am) {
                if (ay && !am) {
                    description = 11;
                } else if (!ay && am) {
                    description = 7;
                } else {
                    description = 15;
                    if (this.isGranularityContents(granularity) && this.compare(granularity, true, local, remote, Policy.subMonitorFor(progress, 30))) {
                        description |= 0x10;
                    }
                }
            }
            progress.done();
            return description;
        }
        if (remote == null) {
            if (localExists) return 2;
            Assert.isTrue(false);
            return description;
        }
        if (!localExists) {
            return 1;
        }
        if (this.compare(granularity, false, local, remote, Policy.subMonitorFor(progress, 30))) return description;
        return 3;
    }

    protected boolean compare(int granularity, boolean force, IResource e1, IRemoteResource e2, IProgressMonitor monitor) {
        boolean timestampEquals = force ? false : this.timestampEquals(e1, e2);
        if (!timestampEquals && this.isGranularityContents(granularity)) {
            boolean bl;
            try {
                monitor.beginTask(null, 100);
                bl = this.contentsEqual(this.getContents(e1, Policy.subMonitorFor(monitor, 50)), this.getContents(e2, Policy.subMonitorFor(monitor, 50)), granularity == 4);
                Object var7_8 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                monitor.done();
                throw throwable;
            }
            monitor.done();
            return bl;
        }
        return timestampEquals;
    }

    protected boolean compare(int granularity, boolean force, IRemoteResource e1, IRemoteResource e2, IProgressMonitor monitor) {
        boolean timestampEquals = force ? false : this.timestampEquals(e1, e2);
        if (!timestampEquals && this.isGranularityContents(granularity)) {
            boolean bl;
            try {
                monitor.beginTask(null, 100);
                bl = this.contentsEqual(this.getContents(e1, Policy.subMonitorFor(monitor, 50)), this.getContents(e2, Policy.subMonitorFor(monitor, 50)), granularity == 4);
                Object var7_8 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                monitor.done();
                throw throwable;
            }
            monitor.done();
            return bl;
        }
        return timestampEquals;
    }

    protected abstract boolean timestampEquals(IResource var1, IRemoteResource var2);

    protected abstract boolean timestampEquals(IRemoteResource var1, IRemoteResource var2);

    protected boolean isGranularityContents(int granularity) {
        return granularity != 1;
    }

    private InputStream getContents(IResource resource, IProgressMonitor monitor) {
        try {
            if (resource instanceof IStorage) {
                return new BufferedInputStream(((IStorage)resource).getContents());
            }
            return null;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private InputStream getContents(IRemoteResource remote, IProgressMonitor monitor) {
        try {
            if (!remote.isContainer()) {
                return new BufferedInputStream(remote.getContents(monitor));
            }
            return null;
        }
        catch (TeamException teamException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean contentsEqual(InputStream is1, InputStream is2, boolean ignoreWhitespace) {
        block29: {
            block28: {
                block26: {
                    block27: {
                        if (is1 == is2) {
                            return true;
                        }
                        if (is1 == null && is2 == null) {
                            return true;
                        }
                        try {
                            try {
                                int c2;
                                int c1;
                                block34: {
                                    block33: {
                                        if (is1 == null) break block33;
                                        if (is2 != null) break block34;
                                    }
                                    Object var6_4 = null;
                                    if (is1 == null) break block26;
                                    break block27;
                                }
                                block15: do {
                                    c1 = is1.read();
                                    while (true) {
                                        if (!ignoreWhitespace || !this.isWhitespace(c1)) break;
                                        c1 = is1.read();
                                    }
                                    c2 = is2.read();
                                    while (true) {
                                        if (!ignoreWhitespace || !this.isWhitespace(c2)) {
                                            if (c1 != -1 || c2 != -1) continue block15;
                                            break block28;
                                        }
                                        c2 = is2.read();
                                    }
                                } while (c1 == c2);
                            }
                            catch (IOException iOException) {}
                            break block29;
                        }
                        catch (Throwable throwable) {
                            Object var6_6 = null;
                            if (is1 != null) {
                                try {
                                    is1.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (is2 == null) throw throwable;
                            try {
                                is2.close();
                                throw throwable;
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                    }
                    try {}
                    catch (IOException iOException) {}
                    is1.close();
                }
                if (is2 == null) return false;
                try {}
                catch (IOException iOException) {}
                is2.close();
                return false;
            }
            Object var6_5 = null;
            if (is1 != null) {
                try {}
                catch (IOException iOException) {}
                is1.close();
            }
            if (is2 == null) return true;
            try {}
            catch (IOException iOException) {}
            is2.close();
            return true;
        }
        Object var6_7 = null;
        if (is1 != null) {
            try {}
            catch (IOException iOException) {}
            is1.close();
        }
        if (is2 == null) return false;
        try {}
        catch (IOException iOException) {
            return false;
        }
        is2.close();
        return false;
    }

    private boolean isWhitespace(int c) {
        if (c == -1) {
            return false;
        }
        return Character.isWhitespace((char)c);
    }

    private IResource getResourceChild(IResource parent, String childName, boolean isContainer) {
        if (parent.getType() == 1) {
            return null;
        }
        if (isContainer) {
            return ((IContainer)parent).getFolder((IPath)new Path(childName));
        }
        return ((IContainer)parent).getFile((IPath)new Path(childName));
    }

    public String toString() {
        return String.valueOf(this.getName()) + RemoteSyncElement.kindToString(this.getSyncKind(1, null));
    }

    public static String kindToString(int kind) {
        String label = "";
        if (kind == 0) {
            label = Policy.bind("RemoteSyncElement.insync");
        } else {
            switch (kind & 0xC) {
                case 12: {
                    label = Policy.bind("RemoteSyncElement.conflicting");
                    break;
                }
                case 4: {
                    label = Policy.bind("RemoteSyncElement.outgoing");
                    break;
                }
                case 8: {
                    label = Policy.bind("RemoteSyncElement.incoming");
                }
            }
            switch (kind & 3) {
                case 3: {
                    label = Policy.bind("concatStrings", label, Policy.bind("RemoteSyncElement.change"));
                    break;
                }
                case 1: {
                    label = Policy.bind("concatStrings", label, Policy.bind("RemoteSyncElement.addition"));
                    break;
                }
                case 2: {
                    label = Policy.bind("concatStrings", label, Policy.bind("RemoteSyncElement.deletion"));
                }
            }
            if ((kind & 0x40) != 0) {
                label = Policy.bind("concatStrings", label, Policy.bind("RemoteSyncElement.manual"));
            }
            if ((kind & 0x20) != 0) {
                label = Policy.bind("concatStrings", label, Policy.bind("RemoteSyncElement.auto"));
            }
        }
        return Policy.bind("RemoteSyncElement.delimit", label);
    }
}

