/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core.sync;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.sync.RemoteContentsCacheEntry;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.core.TeamPlugin;

public class RemoteContentsCache {
    private static final String CACHE_DIRECTORY = ".cache";
    private static final long CACHE_FILE_LIFESPAN = 3600000L;
    private static Map caches = new HashMap();
    private String name;
    private Map cacheEntries;
    private long lastCacheCleanup;
    private int cacheDirSize;
    private ILock lock = Platform.getJobManager().newLock();

    public static synchronized void enableCaching(String cacheId) {
        if (RemoteContentsCache.isCachingEnabled(cacheId)) {
            return;
        }
        RemoteContentsCache cache = new RemoteContentsCache(cacheId);
        try {
            cache.createCacheDirectory();
        }
        catch (TeamException e) {
            TeamPlugin.log(e);
        }
        caches.put(cacheId, cache);
    }

    public static boolean isCachingEnabled(String cacheId) {
        return RemoteContentsCache.getCache(cacheId) != null;
    }

    public static void disableCache(String cacheId) {
        RemoteContentsCache cache = RemoteContentsCache.getCache(cacheId);
        if (cache == null) {
            return;
        }
        caches.remove(cacheId);
        try {
            cache.deleteCacheDirectory();
        }
        catch (TeamException e) {
            TeamPlugin.log(e);
        }
    }

    public static synchronized RemoteContentsCache getCache(String cacheId) {
        return (RemoteContentsCache)caches.get(cacheId);
    }

    private RemoteContentsCache(String name) {
        this.name = name;
    }

    public boolean hasEntry(String id) {
        return this.internalGetCacheEntry(id) != null;
    }

    protected IPath getCachePath() {
        return this.getStateLocation().append(CACHE_DIRECTORY).append(this.name);
    }

    private IPath getStateLocation() {
        return TeamPlugin.getPlugin().getStateLocation();
    }

    private void clearOldCacheEntries() {
        RemoteContentsCacheEntry entry;
        long current = new Date().getTime();
        if (this.lastCacheCleanup != -1L && current - this.lastCacheCleanup < 3600000L) {
            return;
        }
        ArrayList<RemoteContentsCacheEntry> stale = new ArrayList<RemoteContentsCacheEntry>();
        Iterator<Object> iter = this.cacheEntries.values().iterator();
        while (iter.hasNext()) {
            entry = (RemoteContentsCacheEntry)iter.next();
            long lastHit = entry.getLastAccessTimeStamp();
            if (current - lastHit <= 3600000L) continue;
            stale.add(entry);
        }
        iter = stale.iterator();
        while (iter.hasNext()) {
            entry = (RemoteContentsCacheEntry)iter.next();
            entry.dispose();
        }
    }

    private void purgeFromCache(String id) {
        RemoteContentsCacheEntry entry = (RemoteContentsCacheEntry)this.cacheEntries.get(id);
        File f = entry.getFile();
        try {
            this.deleteFile(f);
        }
        catch (TeamException teamException) {}
        this.cacheEntries.remove(id);
    }

    private void createCacheDirectory() throws TeamException {
        IPath cacheLocation = this.getCachePath();
        File file = cacheLocation.toFile();
        if (file.exists()) {
            this.deleteFile(file);
        }
        if (!file.mkdirs()) {
            throw new TeamException(Policy.bind("RemoteContentsCache.fileError", file.getAbsolutePath()));
        }
        this.cacheEntries = new HashMap();
        this.lastCacheCleanup = -1L;
        this.cacheDirSize = 0;
    }

    private void deleteCacheDirectory() throws TeamException {
        this.cacheEntries = null;
        this.lastCacheCleanup = -1L;
        this.cacheDirSize = 0;
        IPath cacheLocation = this.getCachePath();
        File file = cacheLocation.toFile();
        if (file.exists()) {
            try {
                this.deleteFile(file);
            }
            catch (TeamException teamException) {}
        }
    }

    private void deleteFile(File file) throws TeamException {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                this.deleteFile(children[i]);
                ++i;
            }
        }
        if (!file.delete()) {
            throw new TeamException(Policy.bind("RemoteContentsCache.fileError", file.getAbsolutePath()));
        }
    }

    protected void purgeFromCache(RemoteContentsCacheEntry entry) {
        this.purgeFromCache(entry.getId());
    }

    private RemoteContentsCacheEntry internalGetCacheEntry(String id) {
        RemoteContentsCacheEntry entry = (RemoteContentsCacheEntry)this.cacheEntries.get(id);
        if (entry != null) {
            entry.registerHit();
        }
        return entry;
    }

    public synchronized RemoteContentsCacheEntry getCacheEntry(String id) {
        if (this.cacheEntries == null) {
            throw new IllegalStateException(Policy.bind("RemoteContentsCache.cacheDisposed", this.name));
        }
        RemoteContentsCacheEntry entry = this.internalGetCacheEntry(id);
        if (entry == null) {
            entry = this.createCacheEntry(id);
        }
        return entry;
    }

    private RemoteContentsCacheEntry createCacheEntry(String id) {
        this.clearOldCacheEntries();
        String filePath = String.valueOf(this.cacheDirSize++);
        RemoteContentsCacheEntry entry = new RemoteContentsCacheEntry(this, id, filePath);
        this.cacheEntries.put(id, entry);
        return entry;
    }

    public String getName() {
        return this.name;
    }

    protected ILock getLock() {
        return this.lock;
    }
}

