/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core.sync;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.sync.ILocalSyncElement;
import org.eclipse.team.core.sync.IRemoteResource;

public abstract class LocalSyncElement
implements ILocalSyncElement {
    public abstract ILocalSyncElement create(IResource var1, IRemoteResource var2, Object var3);

    protected abstract Object getData();

    protected abstract boolean isIgnored(IResource var1);

    public int getSyncKind(int granularity, IProgressMonitor progress) {
        int sync = 0;
        return sync;
    }

    public String getName() {
        return this.getLocal().getName();
    }

    public boolean isContainer() {
        return this.getLocal().getType() != 1;
    }

    public ILocalSyncElement[] members(IProgressMonitor monitor) throws TeamException {
        try {
            if (this.getLocal().getType() != 1) {
                IResource[] members = ((IContainer)this.getLocal()).members();
                ArrayList<ILocalSyncElement> syncElements = new ArrayList<ILocalSyncElement>(5);
                int i = 0;
                while (i < members.length) {
                    IResource iResource = members[i];
                    if (!this.isIgnored(iResource)) {
                        syncElements.add(this.create(iResource, null, this.getData()));
                    }
                    ++i;
                }
                return syncElements.toArray(new ILocalSyncElement[syncElements.size()]);
            }
            return new ILocalSyncElement[0];
        }
        catch (CoreException e) {
            throw new TeamException(e.getStatus());
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ILocalSyncElement) {
            return this.getLocal().equals((Object)((ILocalSyncElement)other).getLocal());
        }
        return false;
    }
}

